/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.SetOperationNodeUtils;
import com.facebook.presto.sql.planner.optimizations.SymbolMapper;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class PushTableWriteThroughUnion
implements Rule<TableWriterNode> {
    private static final Capture<UnionNode> CHILD = Capture.newCapture();
    private static final Pattern<TableWriterNode> PATTERN = Patterns.tableWriterNode().matching(tableWriter -> !tableWriter.getTablePartitioningScheme().isPresent() && !tableWriter.getPreferredShufflePartitioningScheme().isPresent()).with(Patterns.source().matching(Patterns.union().capturedAs(CHILD)));

    @Override
    public Pattern<TableWriterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isPushTableWriteThroughUnion(session);
    }

    @Override
    public Rule.Result apply(TableWriterNode writerNode, Captures captures, Rule.Context context) {
        UnionNode unionNode = (UnionNode)captures.get(CHILD);
        ImmutableList.Builder rewrittenSources = ImmutableList.builder();
        ArrayList<Map<VariableReferenceExpression, VariableReferenceExpression>> sourceMappings = new ArrayList<Map<VariableReferenceExpression, VariableReferenceExpression>>();
        for (int source = 0; source < unionNode.getSources().size(); ++source) {
            rewrittenSources.add((Object)PushTableWriteThroughUnion.rewriteSource(writerNode, unionNode, source, sourceMappings, context));
        }
        ImmutableListMultimap.Builder unionMappings = ImmutableListMultimap.builder();
        sourceMappings.forEach(mappings -> mappings.forEach((arg_0, arg_1) -> ((ImmutableListMultimap.Builder)unionMappings).put(arg_0, arg_1)));
        ImmutableListMultimap mappings2 = unionMappings.build();
        return Rule.Result.ofPlanNode((PlanNode)new UnionNode(writerNode.getSourceLocation(), context.getIdAllocator().getNextId(), (List)rewrittenSources.build(), (List)ImmutableList.copyOf((Collection)mappings2.keySet()), SetOperationNodeUtils.fromListMultimap((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)mappings2)));
    }

    private static TableWriterNode rewriteSource(TableWriterNode writerNode, UnionNode unionNode, int source, List<Map<VariableReferenceExpression, VariableReferenceExpression>> sourceMappings, Rule.Context context) {
        Map<VariableReferenceExpression, VariableReferenceExpression> inputMappings = PushTableWriteThroughUnion.getInputVariableMapping(unionNode, source);
        ImmutableMap.Builder mappings = ImmutableMap.builder();
        mappings.putAll(inputMappings);
        ImmutableMap.Builder outputMappings = ImmutableMap.builder();
        for (VariableReferenceExpression outputVariable : writerNode.getOutputVariables()) {
            if (inputMappings.containsKey(outputVariable)) {
                outputMappings.put((Object)outputVariable, (Object)inputMappings.get(outputVariable));
                continue;
            }
            VariableReferenceExpression newVariable = context.getVariableAllocator().newVariable(outputVariable);
            outputMappings.put((Object)outputVariable, (Object)newVariable);
            mappings.put((Object)outputVariable, (Object)newVariable);
        }
        sourceMappings.add((Map<VariableReferenceExpression, VariableReferenceExpression>)outputMappings.build());
        SymbolMapper symbolMapper = new SymbolMapper((Map<VariableReferenceExpression, VariableReferenceExpression>)mappings.build(), WarningCollector.NOOP);
        return symbolMapper.map(writerNode, (PlanNode)unionNode.getSources().get(source), context.getIdAllocator().getNextId());
    }

    private static Map<VariableReferenceExpression, VariableReferenceExpression> getInputVariableMapping(UnionNode node, int source) {
        return (Map)node.getOutputVariables().stream().collect(ImmutableMap.toImmutableMap(key -> key, key -> (VariableReferenceExpression)((List)node.getVariableMapping().get(key)).get(source)));
    }
}

