/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.CostProvider;
import com.facebook.presto.cost.PlanCostEstimate;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.EqualityInference;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.DetermineJoinDistributionType;
import com.facebook.presto.sql.planner.optimizations.JoinNodeUtils;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ReorderJoins
implements Rule<JoinNode> {
    private static final Logger log = Logger.get(ReorderJoins.class);
    private final Pattern<JoinNode> joinNodePattern;
    private final CostComparator costComparator;
    private final Metadata metadata;
    private final FunctionResolution functionResolution;
    private final DeterminismEvaluator determinismEvaluator;

    public ReorderJoins(CostComparator costComparator, Metadata metadata) {
        this.costComparator = Objects.requireNonNull(costComparator, "costComparator is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.functionResolution = new FunctionResolution(metadata.getFunctionAndTypeManager());
        this.determinismEvaluator = new RowExpressionDeterminismEvaluator(metadata.getFunctionAndTypeManager());
        this.joinNodePattern = Patterns.join().matching(joinNode -> !joinNode.getDistributionType().isPresent() && joinNode.getType() == JoinNode.Type.INNER && this.determinismEvaluator.isDeterministic(joinNode.getFilter().orElse((RowExpression)LogicalRowExpressions.TRUE_CONSTANT)));
    }

    @Override
    public Pattern<JoinNode> getPattern() {
        return this.joinNodePattern;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.getJoinReorderingStrategy(session) == FeaturesConfig.JoinReorderingStrategy.AUTOMATIC;
    }

    @Override
    public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
        MultiJoinNode multiJoinNode = MultiJoinNode.toMultiJoinNode(joinNode, context.getLookup(), SystemSessionProperties.getMaxReorderedJoins(context.getSession()), this.functionResolution, this.determinismEvaluator);
        JoinEnumerator joinEnumerator = new JoinEnumerator(this.costComparator, multiJoinNode.getFilter(), context, this.determinismEvaluator, this.functionResolution, this.metadata);
        JoinEnumerationResult result = joinEnumerator.chooseJoinOrder(multiJoinNode.getSources(), multiJoinNode.getOutputVariables());
        if (!result.getPlanNode().isPresent()) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(result.getPlanNode().get());
    }

    @VisibleForTesting
    static class JoinEnumerationResult {
        public static final JoinEnumerationResult UNKNOWN_COST_RESULT = new JoinEnumerationResult(Optional.empty(), PlanCostEstimate.unknown());
        public static final JoinEnumerationResult INFINITE_COST_RESULT = new JoinEnumerationResult(Optional.empty(), PlanCostEstimate.infinite());
        private final Optional<PlanNode> planNode;
        private final PlanCostEstimate cost;

        private JoinEnumerationResult(Optional<PlanNode> planNode, PlanCostEstimate cost) {
            this.planNode = Objects.requireNonNull(planNode, "planNode is null");
            this.cost = Objects.requireNonNull(cost, "cost is null");
            Preconditions.checkArgument(((cost.hasUnknownComponents() || cost.equals(PlanCostEstimate.infinite())) && !planNode.isPresent() || (!cost.hasUnknownComponents() || !cost.equals(PlanCostEstimate.infinite())) && planNode.isPresent() ? 1 : 0) != 0, (Object)"planNode should be present if and only if cost is known");
        }

        public Optional<PlanNode> getPlanNode() {
            return this.planNode;
        }

        public PlanCostEstimate getCost() {
            return this.cost;
        }

        static JoinEnumerationResult createJoinEnumerationResult(Optional<PlanNode> planNode, PlanCostEstimate cost) {
            if (cost.hasUnknownComponents()) {
                return UNKNOWN_COST_RESULT;
            }
            if (cost.equals(PlanCostEstimate.infinite())) {
                return INFINITE_COST_RESULT;
            }
            return new JoinEnumerationResult(planNode, cost);
        }
    }

    @VisibleForTesting
    static class MultiJoinNode {
        private final LinkedHashSet<PlanNode> sources;
        private final RowExpression filter;
        private final List<VariableReferenceExpression> outputVariables;

        public MultiJoinNode(LinkedHashSet<PlanNode> sources, RowExpression filter, List<VariableReferenceExpression> outputVariables) {
            Preconditions.checkArgument((sources.size() > 1 ? 1 : 0) != 0, (Object)"sources size is <= 1");
            this.sources = Objects.requireNonNull(sources, "sources is null");
            this.filter = Objects.requireNonNull(filter, "filter is null");
            this.outputVariables = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputVariables, "outputVariables is null"));
            List inputVariables = (List)sources.stream().flatMap(source -> source.getOutputVariables().stream()).collect(ImmutableList.toImmutableList());
            Preconditions.checkArgument((boolean)inputVariables.containsAll(outputVariables), (Object)"inputs do not contain all output variables");
        }

        public RowExpression getFilter() {
            return this.filter;
        }

        public LinkedHashSet<PlanNode> getSources() {
            return this.sources;
        }

        public List<VariableReferenceExpression> getOutputVariables() {
            return this.outputVariables;
        }

        public static Builder builder() {
            return new Builder();
        }

        public int hashCode() {
            return Objects.hash(this.sources, ImmutableSet.copyOf((Collection)LogicalRowExpressions.extractConjuncts((RowExpression)this.filter)), this.outputVariables);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MultiJoinNode)) {
                return false;
            }
            MultiJoinNode other = (MultiJoinNode)obj;
            return this.sources.equals(other.sources) && ImmutableSet.copyOf((Collection)LogicalRowExpressions.extractConjuncts((RowExpression)this.filter)).equals((Object)ImmutableSet.copyOf((Collection)LogicalRowExpressions.extractConjuncts((RowExpression)other.filter))) && this.outputVariables.equals(other.outputVariables);
        }

        static MultiJoinNode toMultiJoinNode(JoinNode joinNode, Lookup lookup, int joinLimit, FunctionResolution functionResolution, DeterminismEvaluator determinismEvaluator) {
            return new JoinNodeFlattener(joinNode, lookup, joinLimit + 1, functionResolution, determinismEvaluator).toMultiJoinNode();
        }

        static class Builder {
            private List<PlanNode> sources;
            private RowExpression filter;
            private List<VariableReferenceExpression> outputVariables;

            Builder() {
            }

            public Builder setSources(PlanNode ... sources) {
                this.sources = ImmutableList.copyOf((Object[])sources);
                return this;
            }

            public Builder setFilter(RowExpression filter) {
                this.filter = filter;
                return this;
            }

            public Builder setOutputVariables(VariableReferenceExpression ... outputVariables) {
                this.outputVariables = ImmutableList.copyOf((Object[])outputVariables);
                return this;
            }

            public MultiJoinNode build() {
                return new MultiJoinNode(new LinkedHashSet<PlanNode>(this.sources), this.filter, this.outputVariables);
            }
        }

        private static class JoinNodeFlattener {
            private final LinkedHashSet<PlanNode> sources = new LinkedHashSet();
            private final List<RowExpression> filters = new ArrayList<RowExpression>();
            private final List<VariableReferenceExpression> outputVariables;
            private final FunctionResolution functionResolution;
            private final DeterminismEvaluator determinismEvaluator;
            private final Lookup lookup;

            JoinNodeFlattener(JoinNode node, Lookup lookup, int sourceLimit, FunctionResolution functionResolution, DeterminismEvaluator determinismEvaluator) {
                Objects.requireNonNull(node, "node is null");
                Preconditions.checkState((node.getType() == JoinNode.Type.INNER ? 1 : 0) != 0, (Object)"join type must be INNER");
                this.outputVariables = node.getOutputVariables();
                this.lookup = Objects.requireNonNull(lookup, "lookup is null");
                this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
                this.determinismEvaluator = Objects.requireNonNull(determinismEvaluator, "determinismEvaluator is null");
                this.flattenNode(node, sourceLimit);
            }

            private void flattenNode(PlanNode node, int limit) {
                PlanNode resolved = this.lookup.resolve(node);
                if (!(resolved instanceof JoinNode) || this.sources.size() > limit - 2) {
                    this.sources.add(node);
                    return;
                }
                JoinNode joinNode = (JoinNode)resolved;
                if (joinNode.getType() != JoinNode.Type.INNER || !this.determinismEvaluator.isDeterministic(joinNode.getFilter().orElse((RowExpression)LogicalRowExpressions.TRUE_CONSTANT)) || joinNode.getDistributionType().isPresent()) {
                    this.sources.add(node);
                    return;
                }
                this.flattenNode(joinNode.getLeft(), limit - 1);
                this.flattenNode(joinNode.getRight(), limit);
                joinNode.getCriteria().stream().map(criteria -> JoinNodeUtils.toRowExpression(criteria, this.functionResolution)).forEach(this.filters::add);
                joinNode.getFilter().ifPresent(this.filters::add);
            }

            MultiJoinNode toMultiJoinNode() {
                return new MultiJoinNode(this.sources, LogicalRowExpressions.and(this.filters), this.outputVariables);
            }
        }
    }

    @VisibleForTesting
    static class JoinEnumerator {
        private final Session session;
        private final CostProvider costProvider;
        private final Ordering<JoinEnumerationResult> resultComparator;
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final RowExpression allFilter;
        private final EqualityInference allFilterInference;
        private final LogicalRowExpressions logicalRowExpressions;
        private final Lookup lookup;
        private final Rule.Context context;
        private final Map<Set<PlanNode>, JoinEnumerationResult> memo = new HashMap<Set<PlanNode>, JoinEnumerationResult>();

        @VisibleForTesting
        JoinEnumerator(CostComparator costComparator, RowExpression filter, Rule.Context context, DeterminismEvaluator determinismEvaluator, FunctionResolution functionResolution, Metadata metadata) {
            this.context = Objects.requireNonNull(context);
            this.session = Objects.requireNonNull(context.getSession(), "session is null");
            this.costProvider = Objects.requireNonNull(context.getCostProvider(), "costProvider is null");
            this.resultComparator = costComparator.forSession(this.session).onResultOf(result -> ((JoinEnumerationResult)result).cost);
            this.idAllocator = Objects.requireNonNull(context.getIdAllocator(), "idAllocator is null");
            this.allFilter = Objects.requireNonNull(filter, "filter is null");
            this.lookup = Objects.requireNonNull(context.getLookup(), "lookup is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.allFilterInference = EqualityInference.createEqualityInference(metadata, filter);
            this.logicalRowExpressions = new LogicalRowExpressions(determinismEvaluator, (StandardFunctionResolution)functionResolution, (FunctionMetadataManager)metadata.getFunctionAndTypeManager());
        }

        private JoinEnumerationResult chooseJoinOrder(LinkedHashSet<PlanNode> sources, List<VariableReferenceExpression> outputVariables) {
            this.context.checkTimeoutNotExhausted();
            ImmutableSet multiJoinKey = ImmutableSet.copyOf(sources);
            JoinEnumerationResult bestResult = this.memo.get(multiJoinKey);
            if (bestResult == null) {
                Preconditions.checkState((sources.size() > 1 ? 1 : 0) != 0, (Object)"sources size is less than or equal to one");
                ImmutableList.Builder resultBuilder = ImmutableList.builder();
                Set<Set<Integer>> partitions = JoinEnumerator.generatePartitions(sources.size());
                for (Set<Integer> partition : partitions) {
                    JoinEnumerationResult result = this.createJoinAccordingToPartitioning(sources, outputVariables, partition);
                    if (result.equals(JoinEnumerationResult.UNKNOWN_COST_RESULT)) {
                        this.memo.put((Set<PlanNode>)multiJoinKey, result);
                        return result;
                    }
                    if (result.equals(JoinEnumerationResult.INFINITE_COST_RESULT)) continue;
                    resultBuilder.add((Object)result);
                }
                ImmutableList results = resultBuilder.build();
                if (results.isEmpty()) {
                    this.memo.put((Set<PlanNode>)multiJoinKey, JoinEnumerationResult.INFINITE_COST_RESULT);
                    return JoinEnumerationResult.INFINITE_COST_RESULT;
                }
                bestResult = (JoinEnumerationResult)this.resultComparator.min((Iterable)results);
                this.memo.put((Set<PlanNode>)multiJoinKey, bestResult);
            }
            bestResult.planNode.ifPresent(planNode -> log.debug("Least cost join was: %s", new Object[]{planNode}));
            return bestResult;
        }

        @VisibleForTesting
        static Set<Set<Integer>> generatePartitions(int totalNodes) {
            Preconditions.checkArgument((totalNodes > 1 ? 1 : 0) != 0, (Object)"totalNodes must be greater than 1");
            Set numbers = (Set)IntStream.range(0, totalNodes).boxed().collect(ImmutableSet.toImmutableSet());
            return (Set)Sets.powerSet((Set)numbers).stream().filter(subSet -> subSet.contains(0)).filter(subSet -> subSet.size() < numbers.size()).collect(ImmutableSet.toImmutableSet());
        }

        @VisibleForTesting
        JoinEnumerationResult createJoinAccordingToPartitioning(LinkedHashSet<PlanNode> sources, List<VariableReferenceExpression> outputVariables, Set<Integer> partitioning) {
            ImmutableList sourceList = ImmutableList.copyOf(sources);
            LinkedHashSet leftSources = partitioning.stream().map(((List)sourceList)::get).collect(Collectors.toCollection(LinkedHashSet::new));
            LinkedHashSet rightSources = sources.stream().filter(source -> !leftSources.contains(source)).collect(Collectors.toCollection(LinkedHashSet::new));
            return this.createJoin(leftSources, rightSources, outputVariables);
        }

        private JoinEnumerationResult createJoin(LinkedHashSet<PlanNode> leftSources, LinkedHashSet<PlanNode> rightSources, List<VariableReferenceExpression> outputVariables) {
            Set rightVariables;
            Set leftVariables = (Set)leftSources.stream().flatMap(node -> node.getOutputVariables().stream()).collect(ImmutableSet.toImmutableSet());
            List<RowExpression> joinPredicates = this.getJoinPredicates(leftVariables, rightVariables = (Set)rightSources.stream().flatMap(node -> node.getOutputVariables().stream()).collect(ImmutableSet.toImmutableSet()));
            List joinConditions = (List)joinPredicates.stream().filter(JoinEnumerator::isJoinEqualityCondition).map(predicate -> JoinEnumerator.toEquiJoinClause((CallExpression)predicate, leftVariables, this.context.getVariableAllocator())).collect(ImmutableList.toImmutableList());
            if (joinConditions.isEmpty()) {
                return JoinEnumerationResult.INFINITE_COST_RESULT;
            }
            List joinFilters = (List)joinPredicates.stream().filter(predicate -> !JoinEnumerator.isJoinEqualityCondition(predicate)).collect(ImmutableList.toImmutableList());
            ImmutableSet requiredJoinVariables = ImmutableSet.builder().addAll(outputVariables).addAll(VariablesExtractor.extractUnique(joinPredicates)).build();
            JoinEnumerationResult leftResult = this.getJoinSource(leftSources, (List)requiredJoinVariables.stream().filter(leftVariables::contains).collect(ImmutableList.toImmutableList()));
            if (leftResult.equals(JoinEnumerationResult.UNKNOWN_COST_RESULT)) {
                return JoinEnumerationResult.UNKNOWN_COST_RESULT;
            }
            if (leftResult.equals(JoinEnumerationResult.INFINITE_COST_RESULT)) {
                return JoinEnumerationResult.INFINITE_COST_RESULT;
            }
            PlanNode left = (PlanNode)leftResult.planNode.orElseThrow(() -> new VerifyException("Plan node is not present"));
            JoinEnumerationResult rightResult = this.getJoinSource(rightSources, (List)requiredJoinVariables.stream().filter(rightVariables::contains).collect(ImmutableList.toImmutableList()));
            if (rightResult.equals(JoinEnumerationResult.UNKNOWN_COST_RESULT)) {
                return JoinEnumerationResult.UNKNOWN_COST_RESULT;
            }
            if (rightResult.equals(JoinEnumerationResult.INFINITE_COST_RESULT)) {
                return JoinEnumerationResult.INFINITE_COST_RESULT;
            }
            PlanNode right = (PlanNode)rightResult.planNode.orElseThrow(() -> new VerifyException("Plan node is not present"));
            List sortedOutputVariables = (List)Stream.concat(left.getOutputVariables().stream(), right.getOutputVariables().stream()).filter(outputVariables::contains).collect(ImmutableList.toImmutableList());
            return this.setJoinNodeProperties(new JoinNode(left.getSourceLocation(), this.idAllocator.getNextId(), JoinNode.Type.INNER, left, right, joinConditions, sortedOutputVariables, joinFilters.isEmpty() ? Optional.empty() : Optional.of(LogicalRowExpressions.and((Collection)joinFilters)), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of()));
        }

        private List<RowExpression> getJoinPredicates(Set<VariableReferenceExpression> leftVariables, Set<VariableReferenceExpression> rightVariables) {
            ImmutableList.Builder joinPredicatesBuilder = ImmutableList.builder();
            EqualityInference.Builder builder = new EqualityInference.Builder(this.metadata);
            StreamSupport.stream(builder.nonInferableConjuncts(this.allFilter).spliterator(), false).map(conjunct -> this.allFilterInference.rewriteExpression((RowExpression)conjunct, (Predicate<VariableReferenceExpression>)((Predicate)variable -> leftVariables.contains(variable) || rightVariables.contains(variable)))).filter(Objects::nonNull).filter(conjunct -> this.allFilterInference.rewriteExpression((RowExpression)conjunct, (Predicate<VariableReferenceExpression>)((Predicate)leftVariables::contains)) == null).filter(conjunct -> this.allFilterInference.rewriteExpression((RowExpression)conjunct, (Predicate<VariableReferenceExpression>)((Predicate)rightVariables::contains)) == null).forEach(arg_0 -> ((ImmutableList.Builder)joinPredicatesBuilder).add(arg_0));
            List<RowExpression> joinEqualities = this.allFilterInference.generateEqualitiesPartitionedBy((Predicate<VariableReferenceExpression>)((Predicate)variable -> leftVariables.contains(variable) || rightVariables.contains(variable))).getScopeEqualities();
            EqualityInference joinInference = EqualityInference.createEqualityInference(this.metadata, joinEqualities.toArray(new RowExpression[0]));
            joinPredicatesBuilder.addAll(joinInference.generateEqualitiesPartitionedBy((Predicate<VariableReferenceExpression>)Predicates.in(leftVariables)).getScopeStraddlingEqualities());
            return joinPredicatesBuilder.build();
        }

        private JoinEnumerationResult getJoinSource(LinkedHashSet<PlanNode> nodes, List<VariableReferenceExpression> outputVariables) {
            if (nodes.size() == 1) {
                PlanNode planNode = (PlanNode)Iterables.getOnlyElement(nodes);
                ImmutableList.Builder predicates = ImmutableList.builder();
                predicates.addAll(this.allFilterInference.generateEqualitiesPartitionedBy((Predicate<VariableReferenceExpression>)((Predicate)outputVariables::contains)).getScopeEqualities());
                EqualityInference.Builder builder = new EqualityInference.Builder(this.metadata);
                StreamSupport.stream(builder.nonInferableConjuncts(this.allFilter).spliterator(), false).map(conjunct -> this.allFilterInference.rewriteExpression((RowExpression)conjunct, (Predicate<VariableReferenceExpression>)((Predicate)outputVariables::contains))).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableList.Builder)predicates).add(arg_0));
                RowExpression filter = this.logicalRowExpressions.combineConjuncts((Collection)predicates.build());
                if (!LogicalRowExpressions.TRUE_CONSTANT.equals((Object)filter)) {
                    planNode = new FilterNode(planNode.getSourceLocation(), this.idAllocator.getNextId(), planNode, filter);
                }
                return this.createJoinEnumerationResult(planNode);
            }
            return this.chooseJoinOrder(nodes, outputVariables);
        }

        private static boolean isJoinEqualityCondition(RowExpression expression) {
            return expression instanceof CallExpression && ((CallExpression)expression).getDisplayName().equals(OperatorType.EQUAL.getFunctionName().getObjectName()) && ((CallExpression)expression).getArguments().size() == 2 && ((CallExpression)expression).getArguments().get(0) instanceof VariableReferenceExpression && ((CallExpression)expression).getArguments().get(1) instanceof VariableReferenceExpression;
        }

        private static JoinNode.EquiJoinClause toEquiJoinClause(CallExpression equality, Set<VariableReferenceExpression> leftVariables, PlanVariableAllocator variableAllocator) {
            Preconditions.checkArgument((equality.getArguments().size() == 2 ? 1 : 0) != 0, (Object)"Unexpected number of arguments in binary operator equals");
            VariableReferenceExpression leftVariable = (VariableReferenceExpression)equality.getArguments().get(0);
            VariableReferenceExpression rightVariable = (VariableReferenceExpression)equality.getArguments().get(1);
            JoinNode.EquiJoinClause equiJoinClause = new JoinNode.EquiJoinClause(leftVariable, rightVariable);
            return leftVariables.contains(leftVariable) ? equiJoinClause : equiJoinClause.flip();
        }

        private JoinEnumerationResult setJoinNodeProperties(JoinNode joinNode) {
            if (QueryCardinalityUtil.isAtMostScalar(joinNode.getRight(), this.lookup)) {
                return this.createJoinEnumerationResult(joinNode.withDistributionType(JoinNode.DistributionType.REPLICATED));
            }
            if (QueryCardinalityUtil.isAtMostScalar(joinNode.getLeft(), this.lookup)) {
                return this.createJoinEnumerationResult(joinNode.flipChildren().withDistributionType(JoinNode.DistributionType.REPLICATED));
            }
            List<JoinEnumerationResult> possibleJoinNodes = this.getPossibleJoinNodes(joinNode, SystemSessionProperties.getJoinDistributionType(this.session));
            Verify.verify((!possibleJoinNodes.isEmpty() ? 1 : 0) != 0, (String)"possibleJoinNodes is empty", (Object[])new Object[0]);
            if (possibleJoinNodes.stream().anyMatch(JoinEnumerationResult.UNKNOWN_COST_RESULT::equals)) {
                return JoinEnumerationResult.UNKNOWN_COST_RESULT;
            }
            return (JoinEnumerationResult)this.resultComparator.min(possibleJoinNodes);
        }

        private List<JoinEnumerationResult> getPossibleJoinNodes(JoinNode joinNode, FeaturesConfig.JoinDistributionType distributionType) {
            Preconditions.checkArgument((joinNode.getType() == JoinNode.Type.INNER ? 1 : 0) != 0, (String)"unexpected join node type: %s", (Object)((Object)joinNode.getType()));
            if (joinNode.isCrossJoin()) {
                return this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.REPLICATED);
            }
            switch (distributionType) {
                case PARTITIONED: {
                    return this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.PARTITIONED);
                }
                case BROADCAST: {
                    return this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.REPLICATED);
                }
                case AUTOMATIC: {
                    ImmutableList.Builder result = ImmutableList.builder();
                    result.addAll(this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.PARTITIONED));
                    result.addAll(this.getPossibleJoinNodes(joinNode, JoinNode.DistributionType.REPLICATED, (Predicate<JoinNode>)((Predicate)node -> DetermineJoinDistributionType.isBelowMaxBroadcastSize(node, this.context))));
                    return result.build();
                }
            }
            throw new IllegalArgumentException("unexpected join distribution type: " + (Object)((Object)distributionType));
        }

        private List<JoinEnumerationResult> getPossibleJoinNodes(JoinNode joinNode, JoinNode.DistributionType distributionType) {
            return this.getPossibleJoinNodes(joinNode, distributionType, (Predicate<JoinNode>)((Predicate)node -> true));
        }

        private List<JoinEnumerationResult> getPossibleJoinNodes(JoinNode joinNode, JoinNode.DistributionType distributionType, Predicate<JoinNode> isAllowed) {
            ImmutableList nodes = ImmutableList.of((Object)((Object)joinNode.withDistributionType(distributionType)), (Object)((Object)joinNode.flipChildren().withDistributionType(distributionType)));
            return (List)nodes.stream().filter(isAllowed).map(this::createJoinEnumerationResult).collect(ImmutableList.toImmutableList());
        }

        private JoinEnumerationResult createJoinEnumerationResult(PlanNode planNode) {
            return JoinEnumerationResult.createJoinEnumerationResult(Optional.of(planNode), this.costProvider.getCost(planNode));
        }
    }
}

