/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;

public class SimplifyCardinalityMapRewriter {
    private static final Set<QualifiedName> MAP_FUNCTIONS = ImmutableSet.of((Object)QualifiedName.of((String)"map_values"), (Object)QualifiedName.of((String)"map_keys"));

    private SimplifyCardinalityMapRewriter() {
    }

    public static Expression rewrite(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(), (Expression)expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private Visitor() {
        }

        public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            ImmutableList.Builder rewrittenArguments = ImmutableList.builder();
            if (node.getName().equals((Object)QualifiedName.of((String)"cardinality"))) {
                for (Expression argument : node.getArguments()) {
                    if (argument instanceof FunctionCall) {
                        FunctionCall functionCall = (FunctionCall)argument;
                        if (MAP_FUNCTIONS.contains(functionCall.getName()) && functionCall.getArguments().size() == 1) {
                            rewrittenArguments.add((Object)treeRewriter.rewrite((Expression)functionCall.getArguments().get(0), (Object)context));
                            continue;
                        }
                    }
                    rewrittenArguments.add((Object)treeRewriter.rewrite(argument, (Object)context));
                }
                return this.newFunctionIfRewritten(node, (ImmutableList.Builder<Expression>)rewrittenArguments);
            }
            for (Expression argument : node.getArguments()) {
                rewrittenArguments.add((Object)treeRewriter.rewrite(argument, (Object)context));
            }
            return this.newFunctionIfRewritten(node, (ImmutableList.Builder<Expression>)rewrittenArguments);
        }

        private Expression newFunctionIfRewritten(FunctionCall node, ImmutableList.Builder<Expression> rewrittenArguments) {
            if (!node.getArguments().equals(rewrittenArguments.build())) {
                return new FunctionCall(node.getName(), (List)rewrittenArguments.build());
            }
            return node;
        }
    }
}

