/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import java.util.List;

public class TransformCorrelatedSingleRowSubqueryToProject
implements Rule<LateralJoinNode> {
    private static final Pattern<LateralJoinNode> PATTERN = Patterns.lateralJoin();

    @Override
    public Pattern<LateralJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LateralJoinNode parent, Captures captures, Rule.Context context) {
        List values = PlanNodeSearcher.searchFrom(parent.getSubquery(), context.getLookup()).recurseOnlyWhen(ProjectNode.class::isInstance).where(ValuesNode.class::isInstance).findAll();
        if (values.size() != 1 || !TransformCorrelatedSingleRowSubqueryToProject.isSingleRowValuesWithNoColumns((ValuesNode)values.get(0))) {
            return Rule.Result.empty();
        }
        List subqueryProjections = PlanNodeSearcher.searchFrom(parent.getSubquery(), context.getLookup()).where(node -> node instanceof ProjectNode && !node.getOutputVariables().equals(parent.getCorrelation())).findAll();
        if (subqueryProjections.isEmpty()) {
            return Rule.Result.ofPlanNode(parent.getInput());
        }
        if (subqueryProjections.size() == 1) {
            Assignments assignments = Assignments.builder().putAll(AssignmentUtils.identitiesAsSymbolReferences(parent.getInput().getOutputVariables())).putAll(((ProjectNode)subqueryProjections.get(0)).getAssignments()).build();
            return Rule.Result.ofPlanNode((PlanNode)this.projectNode(parent.getInput(), assignments, context));
        }
        return Rule.Result.empty();
    }

    private ProjectNode projectNode(PlanNode source, Assignments assignments, Rule.Context context) {
        return new ProjectNode(context.getIdAllocator().getNextId(), source, assignments);
    }

    private static boolean isSingleRowValuesWithNoColumns(ValuesNode values) {
        return values.getRows().size() == 1 && ((List)values.getRows().get(0)).isEmpty();
    }
}

