/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.expressions.RowExpressionRewriter;
import com.facebook.presto.expressions.RowExpressionTreeRewriter;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.StandardWarningCode;
import com.facebook.presto.spi.WarningCodeSupplier;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.plan.StatisticAggregations;
import com.facebook.presto.sql.planner.plan.StatisticAggregationsDescriptor;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterMergeNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SymbolMapper {
    private final Map<String, String> mapping;
    private final TypeProvider types;
    private final WarningCollector warningCollector;

    public SymbolMapper(Map<VariableReferenceExpression, VariableReferenceExpression> mapping, WarningCollector warningCollector) {
        Objects.requireNonNull(mapping, "mapping is null");
        this.mapping = (Map)mapping.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((VariableReferenceExpression)entry.getKey()).getName(), entry -> ((VariableReferenceExpression)entry.getValue()).getName()));
        ImmutableSet.Builder variables = ImmutableSet.builder();
        mapping.entrySet().forEach(entry -> {
            variables.add(entry.getKey());
            variables.add(entry.getValue());
        });
        this.types = TypeProvider.fromVariables((Collection<VariableReferenceExpression>)variables.build());
        this.warningCollector = warningCollector;
    }

    public SymbolMapper(Map<String, String> mapping, TypeProvider types, WarningCollector warningCollector) {
        Objects.requireNonNull(mapping, "mapping is null");
        this.mapping = ImmutableMap.copyOf(mapping);
        this.types = Objects.requireNonNull(types, "types is null");
        this.warningCollector = warningCollector;
    }

    public Symbol map(Symbol symbol) {
        String canonical = symbol.getName();
        while (this.mapping.containsKey(canonical) && !this.mapping.get(canonical).equals(canonical)) {
            canonical = this.mapping.get(canonical);
        }
        return new Symbol(canonical);
    }

    public VariableReferenceExpression map(VariableReferenceExpression variable) {
        String canonical = variable.getName();
        while (this.mapping.containsKey(canonical) && !this.mapping.get(canonical).equals(canonical)) {
            canonical = this.mapping.get(canonical);
        }
        if (canonical.equals(variable.getName())) {
            return variable;
        }
        return new VariableReferenceExpression(variable.getSourceLocation(), canonical, this.types.get((Expression)new SymbolReference(ExpressionTreeUtils.getNodeLocation(variable.getSourceLocation()), canonical)));
    }

    public Expression map(Expression value) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteSymbolReference(SymbolReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Symbol canonical = SymbolMapper.this.map(Symbol.from((Expression)node));
                return canonical.toSymbolReference();
            }
        }, (Expression)value);
    }

    public RowExpression map(RowExpression value) {
        if (OriginalExpressionUtils.isExpression(value)) {
            return OriginalExpressionUtils.castToRowExpression(this.map(OriginalExpressionUtils.castToExpression(value)));
        }
        return RowExpressionTreeRewriter.rewriteWith((RowExpressionRewriter)new RowExpressionRewriter<Void>(){

            public RowExpression rewriteVariableReference(VariableReferenceExpression variable, Void context, RowExpressionTreeRewriter<Void> treeRewriter) {
                return SymbolMapper.this.map(variable);
            }
        }, (RowExpression)value);
    }

    public OrderingScheme map(OrderingScheme orderingScheme) {
        ImmutableList.Builder orderBy = ImmutableList.builder();
        HashMap<VariableReferenceExpression, SortOrder> orderingMap = new HashMap<VariableReferenceExpression, SortOrder>();
        for (VariableReferenceExpression variable2 : orderingScheme.getOrderByVariables()) {
            VariableReferenceExpression translated = this.map(variable2);
            if (!orderingMap.containsKey(translated)) {
                orderBy.add((Object)translated);
                orderingMap.put(translated, orderingScheme.getOrdering(variable2));
                continue;
            }
            if (orderingMap.get(translated) == orderingScheme.getOrdering(variable2)) continue;
            this.warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.MULTIPLE_ORDER_BY, "Multiple ORDER BY for a variable were given, only first provided will be considered"));
        }
        return new OrderingScheme((List)orderBy.build().stream().map((? super T variable) -> new Ordering(variable, (SortOrder)orderingMap.get(variable))).collect(ImmutableList.toImmutableList()));
    }

    public AggregationNode map(AggregationNode node, PlanNode source) {
        return this.map(node, source, node.getId());
    }

    public AggregationNode map(AggregationNode node, PlanNode source, PlanNodeIdAllocator idAllocator) {
        return this.map(node, source, idAllocator.getNextId());
    }

    private AggregationNode map(AggregationNode node, PlanNode source, PlanNodeId newNodeId) {
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        for (Map.Entry entry : node.getAggregations().entrySet()) {
            aggregations.put((Object)this.map((VariableReferenceExpression)entry.getKey()), (Object)this.map((AggregationNode.Aggregation)entry.getValue()));
        }
        return new AggregationNode(source.getSourceLocation(), newNodeId, source, (Map)aggregations.build(), AggregationNode.groupingSets(this.mapAndDistinctVariable(node.getGroupingKeys()), (int)node.getGroupingSetCount(), (Set)node.getGlobalGroupingSets()), this.mapAndDistinctVariable(node.getPreGroupedVariables()), node.getStep(), node.getHashVariable().map(this::map), node.getGroupIdVariable().map(this::map));
    }

    private AggregationNode.Aggregation map(AggregationNode.Aggregation aggregation) {
        return new AggregationNode.Aggregation(new CallExpression(aggregation.getCall().getSourceLocation(), aggregation.getCall().getDisplayName(), aggregation.getCall().getFunctionHandle(), aggregation.getCall().getType(), (List)aggregation.getArguments().stream().map(this::map).collect(ImmutableList.toImmutableList())), aggregation.getFilter().map(this::map), aggregation.getOrderBy().map(this::map), aggregation.isDistinct(), aggregation.getMask().map(this::map));
    }

    public TopNNode map(TopNNode node, PlanNode source, PlanNodeId newNodeId) {
        ImmutableList.Builder variables = ImmutableList.builder();
        ImmutableMap.Builder orderings = ImmutableMap.builder();
        HashSet<VariableReferenceExpression> seenCanonicals = new HashSet<VariableReferenceExpression>(node.getOrderingScheme().getOrderByVariables().size());
        for (VariableReferenceExpression variable2 : node.getOrderingScheme().getOrderByVariables()) {
            VariableReferenceExpression canonical = this.map(variable2);
            if (!seenCanonicals.add(canonical)) continue;
            seenCanonicals.add(canonical);
            variables.add((Object)canonical);
            orderings.put((Object)canonical, (Object)node.getOrderingScheme().getOrdering(variable2));
        }
        ImmutableMap orderingMap = orderings.build();
        return new TopNNode(node.getSourceLocation(), newNodeId, source, node.getCount(), new OrderingScheme((List)variables.build().stream().map((? super T variable) -> new Ordering(variable, (SortOrder)orderingMap.get(variable))).collect(ImmutableList.toImmutableList())), node.getStep());
    }

    public TableWriterNode map(TableWriterNode node, PlanNode source) {
        return this.map(node, source, node.getId());
    }

    public TableWriterNode map(TableWriterNode node, PlanNode source, PlanNodeId newNodeId) {
        ImmutableList columns = (ImmutableList)node.getColumns().stream().map(this::map).collect(ImmutableList.toImmutableList());
        return new TableWriterNode(source.getSourceLocation(), newNodeId, source, node.getTarget(), this.map(node.getRowCountVariable()), this.map(node.getFragmentVariable()), this.map(node.getTableCommitContextVariable()), (List<VariableReferenceExpression>)columns, node.getColumnNames(), node.getNotNullColumnVariables(), node.getTablePartitioningScheme().map((? super T partitioningScheme) -> this.canonicalize((PartitioningScheme)partitioningScheme, source)), node.getPreferredShufflePartitioningScheme().map((? super T partitioningScheme) -> this.canonicalize((PartitioningScheme)partitioningScheme, source)), node.getStatisticsAggregation().map(this::map));
    }

    public StatisticsWriterNode map(StatisticsWriterNode node, PlanNode source) {
        return new StatisticsWriterNode(node.getSourceLocation(), node.getId(), source, node.getTableHandle(), node.getRowCountVariable(), node.isRowCountEnabled(), node.getDescriptor().map(this::map));
    }

    public TableFinishNode map(TableFinishNode node, PlanNode source) {
        return new TableFinishNode(node.getSourceLocation(), node.getId(), source, node.getTarget(), this.map(node.getRowCountVariable()), node.getStatisticsAggregation().map(this::map), node.getStatisticsAggregationDescriptor().map((? super T descriptor) -> descriptor.map(this::map)));
    }

    public TableWriterMergeNode map(TableWriterMergeNode node, PlanNode source) {
        return new TableWriterMergeNode(node.getSourceLocation(), node.getId(), source, this.map(node.getRowCountVariable()), this.map(node.getFragmentVariable()), this.map(node.getTableCommitContextVariable()), node.getStatisticsAggregation().map(this::map));
    }

    private PartitioningScheme canonicalize(PartitioningScheme scheme, PlanNode source) {
        return new PartitioningScheme(scheme.getPartitioning().translateVariable(this::map), this.mapAndDistinctVariable(source.getOutputVariables()), scheme.getHashColumn().map(this::map), scheme.isReplicateNullsAndAny(), scheme.getBucketToPartition());
    }

    private StatisticAggregations map(StatisticAggregations statisticAggregations) {
        Map aggregations = (Map)statisticAggregations.getAggregations().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> this.map((VariableReferenceExpression)entry.getKey()), entry -> this.map((AggregationNode.Aggregation)entry.getValue())));
        return new StatisticAggregations(aggregations, this.mapAndDistinctVariable(statisticAggregations.getGroupingVariables()));
    }

    private StatisticAggregationsDescriptor<VariableReferenceExpression> map(StatisticAggregationsDescriptor<VariableReferenceExpression> descriptor) {
        return descriptor.map(this::map);
    }

    private List<Symbol> mapAndDistinctSymbol(List<Symbol> outputs) {
        HashSet<Symbol> added = new HashSet<Symbol>();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Symbol symbol : outputs) {
            Symbol canonical = this.map(symbol);
            if (!added.add(canonical)) continue;
            builder.add((Object)canonical);
        }
        return builder.build();
    }

    private List<VariableReferenceExpression> mapAndDistinctVariable(List<VariableReferenceExpression> outputs) {
        HashSet<VariableReferenceExpression> added = new HashSet<VariableReferenceExpression>();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (VariableReferenceExpression variable : outputs) {
            VariableReferenceExpression canonical = this.map(variable);
            if (!added.add(canonical)) continue;
            builder.add((Object)canonical);
        }
        return builder.build();
    }

    public static Builder builder(WarningCollector warningCollector) {
        return new Builder(warningCollector);
    }

    public static Builder builder() {
        return new Builder(WarningCollector.NOOP);
    }

    public static class Builder {
        private final ImmutableMap.Builder<VariableReferenceExpression, VariableReferenceExpression> mappingsBuilder;
        private final WarningCollector warningCollector;

        public Builder(WarningCollector warningCollector) {
            this.warningCollector = warningCollector;
            this.mappingsBuilder = ImmutableMap.builder();
        }

        public SymbolMapper build() {
            return new SymbolMapper((Map<VariableReferenceExpression, VariableReferenceExpression>)this.mappingsBuilder.build(), this.warningCollector);
        }

        public void put(VariableReferenceExpression from, VariableReferenceExpression to) {
            this.mappingsBuilder.put((Object)from, (Object)to);
        }
    }
}

