/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.StatisticAggregations;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TableWriterMergeNode
extends InternalPlanNode {
    private final PlanNode source;
    private final VariableReferenceExpression rowCountVariable;
    private final VariableReferenceExpression fragmentVariable;
    private final VariableReferenceExpression tableCommitContextVariable;
    private final Optional<StatisticAggregations> statisticsAggregation;
    private final List<VariableReferenceExpression> outputs;

    @JsonCreator
    public TableWriterMergeNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="rowCountVariable") VariableReferenceExpression rowCountVariable, @JsonProperty(value="fragmentVariable") VariableReferenceExpression fragmentVariable, @JsonProperty(value="tableCommitContextVariable") VariableReferenceExpression tableCommitContextVariable, @JsonProperty(value="statisticsAggregation") Optional<StatisticAggregations> statisticsAggregation) {
        super(sourceLocation, Objects.requireNonNull(id, "id is null"));
        this.source = Objects.requireNonNull(source, "source is null");
        this.rowCountVariable = Objects.requireNonNull(rowCountVariable, "rowCountVariable is null");
        this.fragmentVariable = Objects.requireNonNull(fragmentVariable, "fragmentVariable is null");
        this.tableCommitContextVariable = Objects.requireNonNull(tableCommitContextVariable, "tableCommitContextVariable is null");
        this.statisticsAggregation = Objects.requireNonNull(statisticsAggregation, "statisticsAggregation is null");
        ImmutableList.Builder outputs = ImmutableList.builder().add((Object)rowCountVariable).add((Object)fragmentVariable).add((Object)tableCommitContextVariable);
        statisticsAggregation.ifPresent(aggregation -> {
            outputs.addAll(aggregation.getGroupingVariables());
            outputs.addAll(aggregation.getAggregations().keySet());
        });
        this.outputs = outputs.build();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public VariableReferenceExpression getRowCountVariable() {
        return this.rowCountVariable;
    }

    @JsonProperty
    public VariableReferenceExpression getFragmentVariable() {
        return this.fragmentVariable;
    }

    @JsonProperty
    public VariableReferenceExpression getTableCommitContextVariable() {
        return this.tableCommitContextVariable;
    }

    @JsonProperty
    public Optional<StatisticAggregations> getStatisticsAggregation() {
        return this.statisticsAggregation;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputs;
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new TableWriterMergeNode(this.getSourceLocation(), this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.rowCountVariable, this.fragmentVariable, this.tableCommitContextVariable, this.statisticsAggregation);
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableWriteMerge(this, context);
    }
}

