/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class WindowNode
extends InternalPlanNode {
    private final PlanNode source;
    private final Set<VariableReferenceExpression> prePartitionedInputs;
    private final Specification specification;
    private final int preSortedOrderPrefix;
    private final Map<VariableReferenceExpression, Function> windowFunctions;
    private final Optional<VariableReferenceExpression> hashVariable;

    @JsonCreator
    public WindowNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="specification") Specification specification, @JsonProperty(value="windowFunctions") Map<VariableReferenceExpression, Function> windowFunctions, @JsonProperty(value="hashVariable") Optional<VariableReferenceExpression> hashVariable, @JsonProperty(value="prePartitionedInputs") Set<VariableReferenceExpression> prePartitionedInputs, @JsonProperty(value="preSortedOrderPrefix") int preSortedOrderPrefix) {
        super(sourceLocation, id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(specification, "specification is null");
        Objects.requireNonNull(windowFunctions, "windowFunctions is null");
        Objects.requireNonNull(hashVariable, "hashVariable is null");
        Preconditions.checkArgument((boolean)specification.getPartitionBy().containsAll(prePartitionedInputs), (Object)"prePartitionedInputs must be contained in partitionBy");
        Optional<OrderingScheme> orderingScheme = specification.getOrderingScheme();
        Preconditions.checkArgument((preSortedOrderPrefix == 0 || orderingScheme.isPresent() && preSortedOrderPrefix <= orderingScheme.get().getOrderByVariables().size() ? 1 : 0) != 0, (Object)"Cannot have sorted more symbols than those requested");
        Preconditions.checkArgument((preSortedOrderPrefix == 0 || ImmutableSet.copyOf(prePartitionedInputs).equals((Object)ImmutableSet.copyOf(specification.getPartitionBy())) ? 1 : 0) != 0, (Object)"preSortedOrderPrefix can only be greater than zero if all partition symbols are pre-partitioned");
        this.source = source;
        this.prePartitionedInputs = ImmutableSet.copyOf(prePartitionedInputs);
        this.specification = specification;
        this.windowFunctions = ImmutableMap.copyOf(windowFunctions);
        this.hashVariable = hashVariable;
        this.preSortedOrderPrefix = preSortedOrderPrefix;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return ImmutableList.builder().addAll((Iterable)this.source.getOutputVariables()).addAll(this.windowFunctions.keySet()).build();
    }

    public Set<VariableReferenceExpression> getCreatedVariable() {
        return this.windowFunctions.keySet();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public Specification getSpecification() {
        return this.specification;
    }

    public List<VariableReferenceExpression> getPartitionBy() {
        return this.specification.getPartitionBy();
    }

    public Optional<OrderingScheme> getOrderingScheme() {
        return this.specification.orderingScheme;
    }

    @JsonProperty
    public Map<VariableReferenceExpression, Function> getWindowFunctions() {
        return this.windowFunctions;
    }

    public List<Frame> getFrames() {
        return (List)this.windowFunctions.values().stream().map(Function::getFrame).collect(ImmutableList.toImmutableList());
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getHashVariable() {
        return this.hashVariable;
    }

    @JsonProperty
    public Set<VariableReferenceExpression> getPrePartitionedInputs() {
        return this.prePartitionedInputs;
    }

    @JsonProperty
    public int getPreSortedOrderPrefix() {
        return this.preSortedOrderPrefix;
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitWindow(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new WindowNode(this.getSourceLocation(), this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.specification, this.windowFunctions, this.hashVariable, this.prePartitionedInputs, this.preSortedOrderPrefix);
    }

    @Immutable
    public static final class Function {
        private final CallExpression functionCall;
        private final Frame frame;
        private final boolean ignoreNulls;

        @JsonCreator
        public Function(@JsonProperty(value="functionCall") CallExpression functionCall, @JsonProperty(value="frame") Frame frame, @JsonProperty(value="ignoreNulls") boolean ignoreNulls) {
            this.functionCall = Objects.requireNonNull(functionCall, "functionCall is null");
            this.frame = Objects.requireNonNull(frame, "Frame is null");
            this.ignoreNulls = ignoreNulls;
        }

        @JsonProperty
        public CallExpression getFunctionCall() {
            return this.functionCall;
        }

        @JsonProperty
        public FunctionHandle getFunctionHandle() {
            return this.functionCall.getFunctionHandle();
        }

        @JsonProperty
        public Frame getFrame() {
            return this.frame;
        }

        public int hashCode() {
            return Objects.hash(this.functionCall, this.frame, this.ignoreNulls);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Function other = (Function)obj;
            return Objects.equals(this.functionCall, other.functionCall) && Objects.equals(this.frame, other.frame) && Objects.equals(this.ignoreNulls, other.ignoreNulls);
        }

        @JsonProperty
        public boolean isIgnoreNulls() {
            return this.ignoreNulls;
        }
    }

    @Immutable
    public static class Frame {
        private final WindowType type;
        private final BoundType startType;
        private final Optional<VariableReferenceExpression> startValue;
        private final BoundType endType;
        private final Optional<VariableReferenceExpression> endValue;
        private final Optional<String> originalStartValue;
        private final Optional<String> originalEndValue;

        @JsonCreator
        public Frame(@JsonProperty(value="type") WindowType type, @JsonProperty(value="startType") BoundType startType, @JsonProperty(value="startValue") Optional<VariableReferenceExpression> startValue, @JsonProperty(value="endType") BoundType endType, @JsonProperty(value="endValue") Optional<VariableReferenceExpression> endValue, @JsonProperty(value="originalStartValue") Optional<String> originalStartValue, @JsonProperty(value="originalEndValue") Optional<String> originalEndValue) {
            this.startType = Objects.requireNonNull(startType, "startType is null");
            this.startValue = Objects.requireNonNull(startValue, "startValue is null");
            this.endType = Objects.requireNonNull(endType, "endType is null");
            this.endValue = Objects.requireNonNull(endValue, "endValue is null");
            this.type = Objects.requireNonNull(type, "type is null");
            this.originalStartValue = Objects.requireNonNull(originalStartValue, "originalStartValue is null");
            this.originalEndValue = Objects.requireNonNull(originalEndValue, "originalEndValue is null");
            if (startValue.isPresent()) {
                Preconditions.checkArgument((boolean)originalStartValue.isPresent(), (Object)"originalStartValue must be present if startValue is present");
            }
            if (endValue.isPresent()) {
                Preconditions.checkArgument((boolean)originalEndValue.isPresent(), (Object)"originalEndValue must be present if endValue is present");
            }
        }

        @JsonProperty
        public WindowType getType() {
            return this.type;
        }

        @JsonProperty
        public BoundType getStartType() {
            return this.startType;
        }

        @JsonProperty
        public Optional<VariableReferenceExpression> getStartValue() {
            return this.startValue;
        }

        @JsonProperty
        public BoundType getEndType() {
            return this.endType;
        }

        @JsonProperty
        public Optional<VariableReferenceExpression> getEndValue() {
            return this.endValue;
        }

        @JsonProperty
        public Optional<String> getOriginalStartValue() {
            return this.originalStartValue;
        }

        @JsonProperty
        public Optional<String> getOriginalEndValue() {
            return this.originalEndValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Frame frame = (Frame)o;
            return this.type == frame.type && this.startType == frame.startType && Objects.equals(this.startValue, frame.startValue) && this.endType == frame.endType && Objects.equals(this.endValue, frame.endValue);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.startType, this.startValue, this.endType, this.endValue, this.originalStartValue, this.originalEndValue});
        }

        public static enum BoundType {
            UNBOUNDED_PRECEDING,
            PRECEDING,
            CURRENT_ROW,
            FOLLOWING,
            UNBOUNDED_FOLLOWING;

        }

        public static enum WindowType {
            RANGE,
            ROWS;

        }
    }

    @Immutable
    public static class Specification {
        private final List<VariableReferenceExpression> partitionBy;
        private final Optional<OrderingScheme> orderingScheme;

        @JsonCreator
        public Specification(@JsonProperty(value="partitionBy") List<VariableReferenceExpression> partitionBy, @JsonProperty(value="orderingScheme") Optional<OrderingScheme> orderingScheme) {
            Objects.requireNonNull(partitionBy, "partitionBy is null");
            Objects.requireNonNull(orderingScheme, "orderingScheme is null");
            this.partitionBy = ImmutableList.copyOf(partitionBy);
            this.orderingScheme = Objects.requireNonNull(orderingScheme, "orderingScheme is null");
        }

        @JsonProperty
        public List<VariableReferenceExpression> getPartitionBy() {
            return this.partitionBy;
        }

        @JsonProperty
        public Optional<OrderingScheme> getOrderingScheme() {
            return this.orderingScheme;
        }

        public int hashCode() {
            return Objects.hash(this.partitionBy, this.orderingScheme);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Specification other = (Specification)obj;
            return Objects.equals(this.partitionBy, other.partitionBy) && Objects.equals(this.orderingScheme, other.orderingScheme);
        }
    }
}

