/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tdigest;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class Centroid
implements Comparable<Centroid>,
Serializable {
    private static final AtomicInteger uniqueCount = new AtomicInteger(1);
    private double centroid;
    private double count;
    private transient int id;

    public Centroid(double x) {
        this.start(x, 1.0, uniqueCount.getAndIncrement());
    }

    public Centroid(double x, double w) {
        this.start(x, w, uniqueCount.getAndIncrement());
    }

    public Centroid(double x, double w, int id) {
        this.start(x, w, id);
    }

    private void start(double x, double w, int id) {
        this.id = id;
        this.add(x, w);
    }

    public void add(double x, double w) {
        this.count += w;
        this.centroid += w * (x - this.centroid) / this.count;
    }

    public double getMean() {
        return this.centroid;
    }

    public double getWeight() {
        return this.count;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return "Centroid{mean=" + this.centroid + ", count=" + this.count + '}';
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Centroid centroid = (Centroid)o;
        return this.centroid == centroid.getMean() && this.count == centroid.getWeight();
    }

    @Override
    public int compareTo(Centroid o) {
        Objects.requireNonNull(o);
        int r = Double.compare(this.centroid, o.centroid);
        if (r == 0) {
            r = this.id - o.id;
        }
        return r;
    }
}

