/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tracing;

import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.spi.tracing.Tracer;
import java.util.Objects;

public class QueryStateTracingListener
implements StateMachine.StateChangeListener<QueryState> {
    private QueryState previousState;
    private final Tracer tracer;

    public QueryStateTracingListener(Tracer tracer) {
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
    }

    @Override
    public synchronized void stateChanged(QueryState newState) {
        if (this.previousState == null) {
            this.tracer.startBlock(newState.toString(), "");
            this.previousState = newState;
            return;
        }
        this.tracer.endBlock(this.previousState.toString(), "");
        if (newState.isDone()) {
            this.previousState = newState;
            this.tracer.endTrace("Query finished with state " + (Object)((Object)newState));
            return;
        }
        this.tracer.startBlock(newState.toString(), "");
        this.previousState = newState;
    }
}

