/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockBuilderStatus;
import com.facebook.presto.common.block.VariableWidthBlockBuilder;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.AbstractPrimitiveType;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.TypeSignature;
import com.google.common.net.InetAddresses;
import io.airlift.slice.Slice;
import io.airlift.slice.XxHash64;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IpPrefixType
extends AbstractPrimitiveType
implements FixedWidthType {
    public static final IpPrefixType IPPREFIX = new IpPrefixType();

    private IpPrefixType() {
        super(TypeSignature.parseTypeSignature((String)"ipprefix"), Slice.class);
    }

    public int getFixedSize() {
        return 17;
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new VariableWidthBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()), Math.min(expectedEntries * this.getFixedSize(), maxBlockSizeInBytes));
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return this.createBlockBuilder(null, positionCount);
    }

    public boolean isComparable() {
        return true;
    }

    public boolean isOrderable() {
        return true;
    }

    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        return leftBlock.equals(leftPosition, 0, rightBlock, rightPosition, 0, this.getFixedSize());
    }

    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        return leftBlock.compareTo(leftPosition, 0, this.getFixedSize(), rightBlock, rightPosition, 0, this.getFixedSize());
    }

    public long hash(Block block, int position) {
        return XxHash64.hash((Slice)this.getSlice(block, position));
    }

    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        try {
            String addrString = InetAddresses.toAddrString((InetAddress)InetAddress.getByAddress(this.getSlice(block, position).getBytes(0, 16)));
            String prefixString = Integer.toString(this.getSlice(block, position).getByte(16) & 0xFF);
            return addrString + "/" + prefixString;
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeBytes(block.getSlice(position, 0, this.getFixedSize()), 0, this.getFixedSize());
            blockBuilder.closeEntry();
        }
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        if (length != this.getFixedSize()) {
            throw new IllegalStateException("Expected entry size to be exactly " + this.getFixedSize() + " but was " + length);
        }
        blockBuilder.writeBytes(value, 0, length);
        blockBuilder.closeEntry();
    }

    public final Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, this.getFixedSize());
    }
}

