/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import com.facebook.airlift.configuration.Config;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import io.airlift.units.MaxDuration;
import io.airlift.units.MinDuration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class KuduClientConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private List<String> masterAddresses;
    private Duration defaultAdminOperationTimeout = new Duration(30.0, TimeUnit.SECONDS);
    private Duration defaultOperationTimeout = new Duration(30.0, TimeUnit.SECONDS);
    private Duration defaultSocketReadTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private boolean disableStatistics;
    private boolean schemaEmulationEnabled;
    private String schemaEmulationPrefix = "presto::";
    private boolean kerberosAuthEnabled;
    private String kerberosPrincipal;
    private String kerberosKeytab;
    private boolean kerberosAuthDebugEnabled;

    @NotNull
    @Size(min=1)
    public @NotNull @Size(min=1) List<String> getMasterAddresses() {
        return this.masterAddresses;
    }

    @Config(value="kudu.client.master-addresses")
    public KuduClientConfig setMasterAddresses(String commaSeparatedList) {
        this.masterAddresses = SPLITTER.splitToList((CharSequence)commaSeparatedList);
        return this;
    }

    public KuduClientConfig setMasterAddresses(String ... contactPoints) {
        this.masterAddresses = ImmutableList.copyOf((Object[])contactPoints);
        return this;
    }

    @Config(value="kudu.client.default-admin-operation-timeout")
    public KuduClientConfig setDefaultAdminOperationTimeout(Duration timeout) {
        this.defaultAdminOperationTimeout = timeout;
        return this;
    }

    @MinDuration(value="1s")
    @MaxDuration(value="1h")
    public Duration getDefaultAdminOperationTimeout() {
        return this.defaultAdminOperationTimeout;
    }

    @Config(value="kudu.client.default-operation-timeout")
    public KuduClientConfig setDefaultOperationTimeout(Duration timeout) {
        this.defaultOperationTimeout = timeout;
        return this;
    }

    @MinDuration(value="1s")
    @MaxDuration(value="1h")
    public Duration getDefaultOperationTimeout() {
        return this.defaultOperationTimeout;
    }

    @Config(value="kudu.client.default-socket-read-timeout")
    public KuduClientConfig setDefaultSocketReadTimeout(Duration timeout) {
        this.defaultSocketReadTimeout = timeout;
        return this;
    }

    @MinDuration(value="1s")
    @MaxDuration(value="1h")
    public Duration getDefaultSocketReadTimeout() {
        return this.defaultSocketReadTimeout;
    }

    public boolean isDisableStatistics() {
        return this.disableStatistics;
    }

    @Config(value="kudu.client.disable-statistics")
    public KuduClientConfig setDisableStatistics(boolean disableStatistics) {
        this.disableStatistics = disableStatistics;
        return this;
    }

    public String getSchemaEmulationPrefix() {
        return this.schemaEmulationPrefix;
    }

    @Config(value="kudu.schema-emulation.prefix")
    public KuduClientConfig setSchemaEmulationPrefix(String prefix) {
        this.schemaEmulationPrefix = prefix;
        return this;
    }

    public boolean isSchemaEmulationEnabled() {
        return this.schemaEmulationEnabled;
    }

    @Config(value="kudu.schema-emulation.enabled")
    public KuduClientConfig setSchemaEmulationEnabled(boolean enabled) {
        this.schemaEmulationEnabled = enabled;
        return this;
    }

    public boolean isKerberosAuthEnabled() {
        return this.kerberosAuthEnabled;
    }

    @Config(value="kudu.kerberos-auth.enabled")
    public KuduClientConfig setKerberosAuthEnabled(boolean enabled) {
        this.kerberosAuthEnabled = enabled;
        return this;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    @Config(value="kudu.kerberos-auth.principal")
    public KuduClientConfig setKerberosPrincipal(String principal) {
        this.kerberosPrincipal = principal;
        return this;
    }

    public String getKerberosKeytab() {
        return this.kerberosKeytab;
    }

    @Config(value="kudu.kerberos-auth.keytab")
    public KuduClientConfig setKerberosKeytab(String keytab) {
        this.kerberosKeytab = keytab;
        return this;
    }

    public boolean isKerberosAuthDebugEnabled() {
        return this.kerberosAuthDebugEnabled;
    }

    @Config(value="kudu.kerberos-auth.debug.enabled")
    public KuduClientConfig setKerberosAuthDebugEnabled(boolean enabled) {
        this.kerberosAuthDebugEnabled = enabled;
        return this;
    }
}

