/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.kudu.KuduClientConfig;
import com.facebook.presto.kudu.KuduClientSession;
import com.facebook.presto.kudu.KuduConnector;
import com.facebook.presto.kudu.KuduConnectorId;
import com.facebook.presto.kudu.KuduHandleResolver;
import com.facebook.presto.kudu.KuduMetadata;
import com.facebook.presto.kudu.KuduPageSinkProvider;
import com.facebook.presto.kudu.KuduPageSourceProvider;
import com.facebook.presto.kudu.KuduRecordSetProvider;
import com.facebook.presto.kudu.KuduSplitManager;
import com.facebook.presto.kudu.KuduUtil;
import com.facebook.presto.kudu.procedures.RangePartitionProcedures;
import com.facebook.presto.kudu.properties.KuduTableProperties;
import com.facebook.presto.kudu.schema.NoSchemaEmulation;
import com.facebook.presto.kudu.schema.SchemaEmulation;
import com.facebook.presto.kudu.schema.SchemaEmulationByTableNameConvention;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.procedure.Procedure;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import java.util.Objects;
import javax.inject.Singleton;
import org.apache.kudu.client.KuduClient;

public class KuduModule
extends AbstractModule {
    private final String catalogName;
    private final TypeManager typeManager;

    public KuduModule(String catalogName, TypeManager typeManager) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName qis null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    protected void configure() {
        this.bind(TypeManager.class).toInstance((Object)this.typeManager);
        this.bind(KuduConnector.class).in(Scopes.SINGLETON);
        this.bind(KuduConnectorId.class).toInstance((Object)new KuduConnectorId(this.catalogName));
        this.bind(KuduMetadata.class).in(Scopes.SINGLETON);
        this.bind(KuduTableProperties.class).in(Scopes.SINGLETON);
        this.bind(ConnectorSplitManager.class).to(KuduSplitManager.class).in(Scopes.SINGLETON);
        this.bind(ConnectorRecordSetProvider.class).to(KuduRecordSetProvider.class).in(Scopes.SINGLETON);
        this.bind(ConnectorPageSourceProvider.class).to(KuduPageSourceProvider.class).in(Scopes.SINGLETON);
        this.bind(ConnectorPageSinkProvider.class).to(KuduPageSinkProvider.class).in(Scopes.SINGLETON);
        this.bind(KuduHandleResolver.class).in(Scopes.SINGLETON);
        this.bind(KuduRecordSetProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)this.binder()).bindConfig(KuduClientConfig.class);
        this.bind(RangePartitionProcedures.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), Procedure.class);
    }

    @ProvidesIntoSet
    Procedure getAddRangePartitionProcedure(RangePartitionProcedures procedures) {
        return procedures.getAddPartitionProcedure();
    }

    @ProvidesIntoSet
    Procedure getDropRangePartitionProcedure(RangePartitionProcedures procedures) {
        return procedures.getDropPartitionProcedure();
    }

    @Singleton
    @Provides
    KuduClientSession createKuduClientSession(KuduConnectorId connectorId, KuduClientConfig config) {
        KuduClient client;
        Objects.requireNonNull(config, "config is null");
        if (!config.isKerberosAuthEnabled()) {
            client = KuduUtil.createKuduClient(config);
        } else {
            KuduUtil.initKerberosENV(config.getKerberosPrincipal(), config.getKerberosKeytab(), config.isKerberosAuthDebugEnabled());
            client = KuduUtil.createKuduKerberosClient(config);
        }
        SchemaEmulation strategy = config.isSchemaEmulationEnabled() ? new SchemaEmulationByTableNameConvention(config.getSchemaEmulationPrefix()) : new NoSchemaEmulation();
        return new KuduClientSession(connectorId, client, strategy, config.isKerberosAuthEnabled());
    }
}

