/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.kudu.KuduTableHandle;
import com.facebook.presto.kudu.KuduTableMapping;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.kudu.client.KuduTable;

public class KuduOutputTableHandle
extends KuduTableHandle
implements ConnectorOutputTableHandle,
KuduTableMapping {
    private final boolean generateUUID;
    private final List<Type> columnTypes;
    private final List<Type> originalColumnTypes;

    @JsonCreator
    public KuduOutputTableHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="originalColumnTypes") List<Type> originalColumnTypes, @JsonProperty(value="columnTypes") List<Type> columnTypes, @JsonProperty(value="generateUUID") boolean generateUUID) {
        this(connectorId, schemaTableName, originalColumnTypes, columnTypes, generateUUID, null);
    }

    public KuduOutputTableHandle(String connectorId, SchemaTableName schemaTableName, List<Type> originalColumnTypes, List<Type> columnTypes, boolean generateUUID, KuduTable table) {
        super(connectorId, schemaTableName, table);
        this.columnTypes = ImmutableList.copyOf(columnTypes);
        this.originalColumnTypes = ImmutableList.copyOf(originalColumnTypes);
        this.generateUUID = generateUUID;
    }

    @Override
    @JsonProperty
    public boolean isGenerateUUID() {
        return this.generateUUID;
    }

    @Override
    @JsonProperty
    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    @Override
    @JsonProperty
    public List<Type> getOriginalColumnTypes() {
        return this.originalColumnTypes;
    }
}

