/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import com.facebook.presto.kudu.KuduClientSession;
import com.facebook.presto.kudu.KuduInsertTableHandle;
import com.facebook.presto.kudu.KuduOutputTableHandle;
import com.facebook.presto.kudu.KuduPageSink;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageSinkContext;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.inject.Inject;

public class KuduPageSinkProvider
implements ConnectorPageSinkProvider {
    private final KuduClientSession clientSession;

    @Inject
    public KuduPageSinkProvider(KuduClientSession clientSession) {
        this.clientSession = Objects.requireNonNull(clientSession, "clientSession is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, PageSinkContext pageSinkContext) {
        Preconditions.checkArgument((!pageSinkContext.isCommitRequired() ? 1 : 0) != 0, (Object)"Kudu connector does not support page sink commit");
        Objects.requireNonNull(outputTableHandle, "outputTableHandle is null");
        Preconditions.checkArgument((boolean)(outputTableHandle instanceof KuduOutputTableHandle), (Object)"outputTableHandle is not an instance of KuduOutputTableHandle");
        KuduOutputTableHandle handle = (KuduOutputTableHandle)outputTableHandle;
        return new KuduPageSink(session, this.clientSession, handle);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, PageSinkContext pageSinkContext) {
        Preconditions.checkArgument((!pageSinkContext.isCommitRequired() ? 1 : 0) != 0, (Object)"Kudu connector does not support page sink commit");
        Objects.requireNonNull(insertTableHandle, "insertTableHandle is null");
        Preconditions.checkArgument((boolean)(insertTableHandle instanceof KuduInsertTableHandle), (Object)"insertTableHandle is not an instance of KuduInsertTableHandle");
        KuduInsertTableHandle handle = (KuduInsertTableHandle)insertTableHandle;
        return new KuduPageSink(session, this.clientSession, handle);
    }
}

