/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.kudu.TypeHelper;
import com.facebook.presto.spi.RecordCursor;
import io.airlift.slice.Slice;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.RowResultIterator;

public class KuduRecordCursor
implements RecordCursor {
    private static final Logger log = Logger.get(KuduRecordCursor.class);
    private final KuduScanner scanner;
    private final List<Type> columnTypes;
    private final Field rowDataField;
    private RowResultIterator nextRows;
    protected RowResult currentRow;
    private long totalBytes;
    private long nanoStart;
    private long nanoEnd;
    private boolean started;

    public KuduRecordCursor(KuduScanner scanner, List<Type> columnTypes) {
        this.scanner = scanner;
        this.columnTypes = columnTypes;
        Field field = null;
        try {
            field = RowResult.class.getDeclaredField("rawData");
            field.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        this.rowDataField = field;
    }

    public long getCompletedBytes() {
        return this.totalBytes;
    }

    public long getReadTimeNanos() {
        return this.nanoStart > 0L ? (this.nanoEnd == 0L ? System.nanoTime() : this.nanoEnd) - this.nanoStart : 0L;
    }

    public Type getType(int field) {
        return this.columnTypes.get(field);
    }

    protected int mapping(int field) {
        return field;
    }

    public boolean advanceNextPosition() {
        boolean needNextRows;
        boolean bl = needNextRows = !this.started || !this.nextRows.hasNext();
        if (!this.started) {
            this.started = true;
            this.nanoStart = System.nanoTime();
        }
        if (needNextRows) {
            this.currentRow = null;
            try {
                do {
                    if (!this.scanner.hasMoreRows()) {
                        return false;
                    }
                    this.nextRows = this.scanner.nextRows();
                } while (!this.nextRows.hasNext());
                log.debug("Fetched " + this.nextRows.getNumRows() + " rows");
            }
            catch (KuduException e) {
                throw new RuntimeException(e);
            }
        }
        this.currentRow = this.nextRows.next();
        this.totalBytes += (long)this.getRowLength();
        return true;
    }

    private org.apache.kudu.util.Slice getCurrentRowRawData() {
        if (this.rowDataField != null && this.currentRow != null) {
            try {
                return (org.apache.kudu.util.Slice)this.rowDataField.get(this.currentRow);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return null;
    }

    private int getRowLength() {
        org.apache.kudu.util.Slice rawData = this.getCurrentRowRawData();
        if (rawData != null) {
            return rawData.length();
        }
        return this.columnTypes.size();
    }

    public boolean getBoolean(int field) {
        int index = this.mapping(field);
        return TypeHelper.getBoolean(this.columnTypes.get(field), this.currentRow, index);
    }

    public long getLong(int field) {
        int index = this.mapping(field);
        return TypeHelper.getLong(this.columnTypes.get(field), this.currentRow, index);
    }

    public double getDouble(int field) {
        int index = this.mapping(field);
        return TypeHelper.getDouble(this.columnTypes.get(field), this.currentRow, index);
    }

    public Slice getSlice(int field) {
        int index = this.mapping(field);
        return TypeHelper.getSlice(this.columnTypes.get(field), this.currentRow, index);
    }

    public Object getObject(int field) {
        int index = this.mapping(field);
        return TypeHelper.getObject(this.columnTypes.get(field), this.currentRow, index);
    }

    public boolean isNull(int field) {
        int mappedField = this.mapping(field);
        return mappedField >= 0 && this.currentRow.isNull(mappedField);
    }

    public void close() {
        this.nanoEnd = System.nanoTime();
        this.currentRow = null;
        this.nextRows = null;
    }
}

