/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.cache.Cache;
import com.jayway.jsonpath.spi.cache.CacheProvider;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.function.JsonPathCache;
import org.apache.pinot.spi.annotations.ScalarFunction;
import org.apache.pinot.spi.utils.JsonUtils;

public class JsonFunctions {
    private static final Object[] EMPTY = new Object[0];
    private static final Predicate[] NO_PREDICATES = new Predicate[0];
    private static final ParseContext PARSE_CONTEXT = JsonPath.using((Configuration)new Configuration.ConfigurationBuilder().jsonProvider((JsonProvider)new ArrayAwareJacksonJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build());

    private JsonFunctions() {
    }

    @ScalarFunction
    public static String toJsonMapStr(Map map) throws JsonProcessingException {
        return JsonUtils.objectToString((Object)map);
    }

    @ScalarFunction
    public static String jsonFormat(Object object) throws JsonProcessingException {
        return JsonUtils.objectToString((Object)object);
    }

    @ScalarFunction
    public static Object jsonPath(Object object, String jsonPath) {
        if (object instanceof String) {
            return PARSE_CONTEXT.parse((String)object).read(jsonPath, NO_PREDICATES);
        }
        return object == null ? null : PARSE_CONTEXT.parse(object).read(jsonPath, NO_PREDICATES);
    }

    @ScalarFunction
    public static Object[] jsonPathArray(Object object, String jsonPath) {
        if (object instanceof String) {
            return JsonFunctions.convertObjectToArray(PARSE_CONTEXT.parse((String)object).read(jsonPath, NO_PREDICATES));
        }
        return JsonFunctions.convertObjectToArray(PARSE_CONTEXT.parse(object).read(jsonPath, NO_PREDICATES));
    }

    @ScalarFunction
    public static Object[] jsonPathArrayDefaultEmpty(Object object, String jsonPath) {
        try {
            Object[] result = object == null ? null : JsonFunctions.jsonPathArray(object, jsonPath);
            return result == null ? EMPTY : result;
        }
        catch (Exception e) {
            return EMPTY;
        }
    }

    private static Object[] convertObjectToArray(Object arrayObject) {
        if (arrayObject instanceof List) {
            return ((List)arrayObject).toArray();
        }
        if (arrayObject instanceof Object[]) {
            return (Object[])arrayObject;
        }
        if (arrayObject == null) {
            return null;
        }
        return new Object[]{arrayObject};
    }

    @ScalarFunction
    public static String jsonPathString(Object object, String jsonPath) throws JsonProcessingException {
        Object jsonValue = JsonFunctions.jsonPath(object, jsonPath);
        if (jsonValue instanceof String) {
            return (String)jsonValue;
        }
        return jsonValue == null ? null : JsonUtils.objectToString((Object)jsonValue);
    }

    @ScalarFunction
    public static String jsonPathString(Object object, String jsonPath, String defaultValue) {
        try {
            Object jsonValue = JsonFunctions.jsonPath(object, jsonPath);
            if (jsonValue instanceof String) {
                return (String)jsonValue;
            }
            return jsonValue == null ? defaultValue : JsonUtils.objectToString((Object)jsonValue);
        }
        catch (Exception ignore) {
            return defaultValue;
        }
    }

    @ScalarFunction
    public static long jsonPathLong(Object object, String jsonPath) {
        return JsonFunctions.jsonPathLong(object, jsonPath, Long.MIN_VALUE);
    }

    @ScalarFunction
    public static long jsonPathLong(Object object, String jsonPath, long defaultValue) {
        try {
            Object jsonValue = JsonFunctions.jsonPath(object, jsonPath);
            if (jsonValue == null) {
                return defaultValue;
            }
            if (jsonValue instanceof Number) {
                return ((Number)jsonValue).longValue();
            }
            return Long.parseLong(jsonValue.toString());
        }
        catch (Exception ignore) {
            return defaultValue;
        }
    }

    @ScalarFunction
    public static double jsonPathDouble(Object object, String jsonPath) {
        return JsonFunctions.jsonPathDouble(object, jsonPath, Double.NaN);
    }

    @ScalarFunction
    public static double jsonPathDouble(Object object, String jsonPath, double defaultValue) {
        try {
            Object jsonValue = JsonFunctions.jsonPath(object, jsonPath);
            if (jsonValue == null) {
                return defaultValue;
            }
            if (jsonValue instanceof Number) {
                return ((Number)jsonValue).doubleValue();
            }
            return Double.parseDouble(jsonValue.toString());
        }
        catch (Exception ignore) {
            return defaultValue;
        }
    }

    static {
        CacheProvider.setCache((Cache)new JsonPathCache());
    }

    @VisibleForTesting
    static class ArrayAwareJacksonJsonProvider
    extends JacksonJsonProvider {
        ArrayAwareJacksonJsonProvider() {
        }

        public boolean isArray(Object obj) {
            return obj instanceof List || obj instanceof Object[];
        }

        public Object getArrayIndex(Object obj, int idx) {
            if (obj instanceof Object[]) {
                return ((Object[])obj)[idx];
            }
            return super.getArrayIndex(obj, idx);
        }

        public int length(Object obj) {
            if (obj instanceof Object[]) {
                return ((Object[])obj).length;
            }
            return super.length(obj);
        }

        public Iterable<?> toIterable(Object obj) {
            if (obj instanceof Object[]) {
                return Arrays.asList((Object[])obj);
            }
            return super.toIterable(obj);
        }
    }
}

