/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metrics.AbstractMetrics;

public enum ControllerGauge implements AbstractMetrics.Gauge
{
    NUMBER_OF_REPLICAS("replicas", false),
    PERCENT_OF_REPLICAS("percent", false),
    SEGMENTS_IN_ERROR_STATE("segments", false),
    PERCENT_SEGMENTS_AVAILABLE("segments", false),
    SEGMENT_COUNT("SegmentCount", false),
    IDEALSTATE_ZNODE_SIZE("idealstate", false),
    IDEALSTATE_ZNODE_BYTE_SIZE("idealstate", false),
    REALTIME_TABLE_COUNT("TableCount", true),
    OFFLINE_TABLE_COUNT("TableCount", true),
    DISABLED_TABLE_COUNT("TableCount", true),
    PERIODIC_TASK_NUM_TABLES_PROCESSED("PeriodicTaskNumTablesProcessed", true),
    NUM_MINION_TASKS_IN_PROGRESS("NumMinionTasksInProgress", true),
    NUM_MINION_SUBTASKS_WAITING("NumMinionSubtasksWaiting", true),
    NUM_MINION_SUBTASKS_RUNNING("NumMinionSubtasksRunning", true),
    NUM_MINION_SUBTASKS_ERROR("NumMinionSubtasksError", true),
    PERCENT_MINION_SUBTASKS_IN_QUEUE("PercentMinionSubtasksInQueue", true),
    PERCENT_MINION_SUBTASKS_IN_ERROR("PercentMinionSubtasksInError", true),
    PINOT_CONTROLLER_LEADER("PinotControllerLeader", true),
    PINOT_LEAD_CONTROLLER_RESOURCE_ENABLED("PinotLeadControllerResourceEnabled", true),
    CONTROLLER_LEADER_PARTITION_COUNT("ControllerLeaderPartitionCount", true),
    OFFLINE_TABLE_ESTIMATED_SIZE("OfflineTableEstimatedSize", false),
    TABLE_QUOTA("TableQuotaBasedOnTableConfig", false),
    TABLE_STORAGE_QUOTA_UTILIZATION("TableStorageQuotaUtilization", false),
    TABLE_STORAGE_EST_MISSING_SEGMENT_PERCENT("TableStorageEstMissingSegmentPercent", false),
    CRON_SCHEDULER_JOB_SCHEDULED("cronSchedulerJobScheduled", false),
    TASK_STATUS("taskStatus", false),
    DROPPED_MINION_INSTANCES("droppedMinionInstances", true),
    ONLINE_MINION_INSTANCES("onlineMinionInstances", true);

    private final String _gaugeName;
    private final String _unit;
    private final boolean _global;

    private ControllerGauge(String unit, boolean global) {
        this._unit = unit;
        this._global = global;
        this._gaugeName = Utils.toCamelCase(this.name().toLowerCase());
    }

    @Override
    public String getGaugeName() {
        return this._gaugeName;
    }

    @Override
    public String getUnit() {
        return this._unit;
    }

    @Override
    public boolean isGlobal() {
        return this._global;
    }
}

