/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.metrics.PinotMetricUtils;
import org.apache.pinot.spi.metrics.PinotGauge;
import org.apache.pinot.spi.metrics.PinotMetricName;
import org.apache.pinot.spi.metrics.PinotMetricsRegistry;

public class ValidationMetrics {
    private static final double MILLIS_PER_HOUR = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
    private final PinotMetricsRegistry _metricsRegistry;
    private final Map<String, Long> _gaugeValues = new HashMap<String, Long>();
    private final Set<PinotMetricName> _metricNames = new HashSet<PinotMetricName>();
    private final StoredValueGaugeFactory _storedValueGaugeFactory = new StoredValueGaugeFactory();
    private final CurrentTimeMillisDeltaGaugeHoursFactory _currentTimeMillisDeltaGaugeHoursFactory = new CurrentTimeMillisDeltaGaugeHoursFactory();

    public ValidationMetrics(PinotMetricsRegistry metricsRegistry) {
        this._metricsRegistry = metricsRegistry;
    }

    public void updateMissingSegmentCountGauge(String resource, int missingSegmentCount) {
        this.makeGauge(resource, ValidationMetricName.MISSING_SEGMENT_COUNT, this._storedValueGaugeFactory, missingSegmentCount);
    }

    public void cleanupMissingSegmentCountGauge(String resource) {
        this.removeGauge(resource, ValidationMetricName.MISSING_SEGMENT_COUNT);
    }

    public void updateOfflineSegmentDelayGauge(String resource, long lastOfflineSegmentTime) {
        this.makeGauge(resource, ValidationMetricName.OFFLINE_SEGMENT_DELAY_HOURS, this._currentTimeMillisDeltaGaugeHoursFactory, lastOfflineSegmentTime);
    }

    public void cleanupOfflineSegmentDelayGauge(String resource) {
        this.removeGauge(resource, ValidationMetricName.OFFLINE_SEGMENT_DELAY_HOURS);
    }

    public void updateLastPushTimeGauge(String resource, long lastPushTimeMillis) {
        this.makeGauge(resource, ValidationMetricName.LAST_PUSH_TIME_DELAY_HOURS, this._currentTimeMillisDeltaGaugeHoursFactory, lastPushTimeMillis);
    }

    public void cleanupLastPushTimeGauge(String resource) {
        this.removeGauge(resource, ValidationMetricName.LAST_PUSH_TIME_DELAY_HOURS);
    }

    public void updateTotalDocumentCountGauge(String resource, long documentCount) {
        this.makeGauge(resource, ValidationMetricName.TOTAL_DOCUMENT_COUNT, this._storedValueGaugeFactory, documentCount);
    }

    public void cleanupTotalDocumentCountGauge(String resource) {
        this.removeGauge(resource, ValidationMetricName.TOTAL_DOCUMENT_COUNT);
    }

    public void updateNonConsumingPartitionCountMetric(String resource, int partitionCount) {
        this.makeGauge(resource, ValidationMetricName.NON_CONSUMING_PARTITION_COUNT, this._storedValueGaugeFactory, partitionCount);
    }

    public void updateSegmentCountGauge(String resource, long segmentCount) {
        this.makeGauge(resource, ValidationMetricName.SEGMENT_COUNT, this._storedValueGaugeFactory, segmentCount);
    }

    public void cleanupSegmentCountGauge(String resource) {
        this.removeGauge(resource, ValidationMetricName.SEGMENT_COUNT);
    }

    @VisibleForTesting
    public static String makeGaugeName(String resource, String gaugeName) {
        return "pinot.controller." + resource + "." + gaugeName;
    }

    private PinotMetricName makeMetricName(String gaugeName) {
        return PinotMetricUtils.makePinotMetricName(ValidationMetrics.class, gaugeName);
    }

    private void makeGauge(String resource, ValidationMetricName validationMetricName, GaugeFactory<?> gaugeFactory, long value) {
        String fullGaugeName = ValidationMetrics.makeGaugeName(resource, validationMetricName.getMetricName());
        PinotMetricName metricName = this.makeMetricName(fullGaugeName);
        if (!this._gaugeValues.containsKey(fullGaugeName)) {
            this._gaugeValues.put(fullGaugeName, value);
            PinotMetricUtils.makeGauge(this._metricsRegistry, metricName, gaugeFactory.buildGauge(fullGaugeName));
            this._metricNames.add(metricName);
        } else {
            this._gaugeValues.put(fullGaugeName, value);
        }
    }

    private void removeGauge(String resource, ValidationMetricName validationMetricName) {
        String fullGaugeName = ValidationMetrics.makeGaugeName(resource, validationMetricName.getMetricName());
        PinotMetricName pinotMetricName = this.makeMetricName(fullGaugeName);
        PinotMetricUtils.removeMetric(this._metricsRegistry, pinotMetricName);
        this._metricNames.remove(pinotMetricName);
        this._gaugeValues.remove(fullGaugeName);
    }

    public void unregisterAllMetrics() {
        for (PinotMetricName metricName : this._metricNames) {
            PinotMetricUtils.removeMetric(this._metricsRegistry, metricName);
        }
        this._metricNames.clear();
        this._gaugeValues.clear();
    }

    @VisibleForTesting
    public long getValueOfGauge(String fullGaugeName) {
        Long value = this._gaugeValues.get(fullGaugeName);
        if (value == null) {
            return 0L;
        }
        return value;
    }

    public static enum ValidationMetricName {
        MISSING_SEGMENT_COUNT("missingSegmentCount"),
        OFFLINE_SEGMENT_DELAY_HOURS("offlineSegmentDelayHours"),
        LAST_PUSH_TIME_DELAY_HOURS("lastPushTimeDelayHours"),
        TOTAL_DOCUMENT_COUNT("TotalDocumentCount"),
        NON_CONSUMING_PARTITION_COUNT("NonConsumingPartitionCount"),
        SEGMENT_COUNT("SegmentCount");

        private final String _metricName;

        private ValidationMetricName(String metricName) {
            this._metricName = metricName;
        }

        public String getMetricName() {
            return this._metricName;
        }
    }

    private class CurrentTimeMillisDeltaGaugeHoursFactory
    implements GaugeFactory<Double> {
        private CurrentTimeMillisDeltaGaugeHoursFactory() {
        }

        @Override
        public PinotGauge<Double> buildGauge(String key) {
            return new CurrentTimeMillisDeltaGaugeHours(key);
        }
    }

    private class StoredValueGaugeFactory
    implements GaugeFactory<Long> {
        private StoredValueGaugeFactory() {
        }

        @Override
        public PinotGauge<Long> buildGauge(String key) {
            return new StoredValueGauge(key);
        }
    }

    private static interface GaugeFactory<T> {
        public PinotGauge<T> buildGauge(String var1);
    }

    private class CurrentTimeMillisDeltaGaugeHours
    implements PinotGauge<Double> {
        private final String _key;

        public CurrentTimeMillisDeltaGaugeHours(String key) {
            this._key = key;
        }

        public Double value() {
            Long gaugeValue = (Long)ValidationMetrics.this._gaugeValues.get(this._key);
            if (gaugeValue != null && gaugeValue != Long.MIN_VALUE) {
                return (double)(System.currentTimeMillis() - gaugeValue) / MILLIS_PER_HOUR;
            }
            return Double.MIN_VALUE;
        }

        public Object getMetric() {
            return this.getGauge();
        }

        public Object getGauge() {
            return PinotMetricUtils.makePinotGauge(avoid -> this.value()).getGauge();
        }
    }

    private class StoredValueGauge
    implements PinotGauge<Long> {
        private final String _key;

        public StoredValueGauge(String key) {
            this._key = key;
        }

        public Long value() {
            return (Long)ValidationMetrics.this._gaugeValues.get(this._key);
        }

        public Object getGauge() {
            return PinotMetricUtils.makePinotGauge(avoid -> this.value()).getGauge();
        }

        public Object getMetric() {
            return this.getGauge();
        }
    }
}

