/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.minion;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.pinot.common.minion.MinionRequestURLBuilder;
import org.apache.pinot.spi.annotations.InterfaceAudience;
import org.apache.pinot.spi.annotations.InterfaceStability;
import org.apache.pinot.spi.utils.JsonUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MinionClient {
    private static final CloseableHttpClient HTTP_CLIENT = HttpClientBuilder.create().build();
    private static final String ACCEPT = "accept";
    private static final String APPLICATION_JSON = "application/json";
    private static final String HTTP = "http";
    private final String _controllerUrl;

    public MinionClient(String controllerHost, String controllerPort) {
        this(HTTP, controllerHost, controllerPort);
    }

    public MinionClient(String scheme, String controllerHost, String controllerPort) {
        this(String.format("%s://%s:%s", scheme, controllerHost, controllerPort));
    }

    public MinionClient(String controllerUrl) {
        this._controllerUrl = controllerUrl;
    }

    public String getControllerUrl() {
        return this._controllerUrl;
    }

    public Map<String, String> scheduleMinionTasks(@Nullable String taskType, @Nullable String tableNameWithType) throws IOException {
        HttpPost httpPost = this.createHttpPostRequest(MinionRequestURLBuilder.baseUrl(this.getControllerUrl()).forTaskSchedule(taskType, tableNameWithType));
        CloseableHttpResponse response = HTTP_CLIENT.execute((HttpUriRequest)httpPost);
        int statusCode = response.getStatusLine().getStatusCode();
        String responseString = IOUtils.toString((InputStream)response.getEntity().getContent());
        if (statusCode >= 400) {
            throw new HttpException(String.format("Unable to schedule minion tasks. Error code %d, Error message: %s", statusCode, responseString));
        }
        return (Map)JsonUtils.stringToObject((String)responseString, (TypeReference)new TypeReference<Map<String, String>>(){});
    }

    public Map<String, String> getTasksStates(String taskType) throws IOException {
        HttpGet httpGet = this.createHttpGetRequest(MinionRequestURLBuilder.baseUrl(this.getControllerUrl()).forTasksStates(taskType));
        CloseableHttpResponse response = HTTP_CLIENT.execute((HttpUriRequest)httpGet);
        int statusCode = response.getStatusLine().getStatusCode();
        String responseString = IOUtils.toString((InputStream)response.getEntity().getContent());
        if (statusCode >= 400) {
            throw new HttpException(String.format("Unable to get tasks states map. Error code %d, Error message: %s", statusCode, responseString));
        }
        return (Map)JsonUtils.stringToObject((String)responseString, (TypeReference)new TypeReference<Map<String, String>>(){});
    }

    public String getTaskState(String taskName) throws IOException {
        HttpGet httpGet = this.createHttpGetRequest(MinionRequestURLBuilder.baseUrl(this.getControllerUrl()).forTaskState(taskName));
        CloseableHttpResponse response = HTTP_CLIENT.execute((HttpUriRequest)httpGet);
        int statusCode = response.getStatusLine().getStatusCode();
        String responseString = IOUtils.toString((InputStream)response.getEntity().getContent());
        if (statusCode >= 400) {
            throw new HttpException(String.format("Unable to get state for task: %s. Error code %d, Error message: %s", taskName, statusCode, responseString));
        }
        return responseString;
    }

    private HttpGet createHttpGetRequest(String uri) {
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setHeader(ACCEPT, APPLICATION_JSON);
        return httpGet;
    }

    private HttpPost createHttpPostRequest(String uri) {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader(ACCEPT, APPLICATION_JSON);
        return httpPost;
    }
}

