/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.minion;

import org.apache.helix.ZNRecord;
import org.apache.pinot.common.minion.BaseTaskMetadata;

public class RealtimeToOfflineSegmentsTaskMetadata
extends BaseTaskMetadata {
    private static final String WATERMARK_KEY = "watermarkMs";
    private final String _tableNameWithType;
    private final long _watermarkMs;

    public RealtimeToOfflineSegmentsTaskMetadata(String tableNameWithType, long watermarkMs) {
        this._tableNameWithType = tableNameWithType;
        this._watermarkMs = watermarkMs;
    }

    @Override
    public String getTableNameWithType() {
        return this._tableNameWithType;
    }

    public long getWatermarkMs() {
        return this._watermarkMs;
    }

    public static RealtimeToOfflineSegmentsTaskMetadata fromZNRecord(ZNRecord znRecord) {
        long watermark = znRecord.getLongField(WATERMARK_KEY, 0L);
        return new RealtimeToOfflineSegmentsTaskMetadata(znRecord.getId(), watermark);
    }

    @Override
    public ZNRecord toZNRecord() {
        ZNRecord znRecord = new ZNRecord(this._tableNameWithType);
        znRecord.setLongField(WATERMARK_KEY, this._watermarkMs);
        return znRecord;
    }
}

