/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request.context;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.pinot.common.request.context.predicate.Predicate;

public class FilterContext {
    private final Type _type;
    private final List<FilterContext> _children;
    private final Predicate _predicate;

    public FilterContext(Type type, List<FilterContext> children, Predicate predicate) {
        this._type = type;
        this._children = children;
        this._predicate = predicate;
    }

    public Type getType() {
        return this._type;
    }

    public List<FilterContext> getChildren() {
        return this._children;
    }

    public Predicate getPredicate() {
        return this._predicate;
    }

    public void getColumns(Set<String> columns) {
        if (this._children != null) {
            for (FilterContext child : this._children) {
                child.getColumns(columns);
            }
        } else {
            this._predicate.getLhs().getColumns(columns);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilterContext)) {
            return false;
        }
        FilterContext that = (FilterContext)o;
        return this._type == that._type && Objects.equals(this._children, that._children) && Objects.equals(this._predicate, that._predicate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._type, this._children, this._predicate});
    }

    public String toString() {
        switch (this._type) {
            case AND: {
                StringBuilder stringBuilder = new StringBuilder().append('(').append(this._children.get(0).toString());
                int numChildren = this._children.size();
                for (int i = 1; i < numChildren; ++i) {
                    stringBuilder.append(" AND ").append(this._children.get(i).toString());
                }
                return stringBuilder.append(')').toString();
            }
            case OR: {
                StringBuilder stringBuilder = new StringBuilder().append('(').append(this._children.get(0).toString());
                int numChildren = this._children.size();
                for (int i = 1; i < numChildren; ++i) {
                    stringBuilder.append(" OR ").append(this._children.get(i).toString());
                }
                return stringBuilder.append(')').toString();
            }
            case PREDICATE: {
                return this._predicate.toString();
            }
        }
        throw new IllegalStateException();
    }

    public static enum Type {
        AND,
        OR,
        NOT,
        PREDICATE;

    }
}

