/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.spi.utils.ByteArray;

public interface DataTable {
    public static final String EXCEPTION_METADATA_KEY = "Exception";

    public void addException(ProcessingException var1);

    public void addException(int var1, String var2);

    public Map<Integer, String> getExceptions();

    public byte[] toBytes() throws IOException;

    public Map<String, String> getMetadata();

    public DataSchema getDataSchema();

    public int getNumberOfRows();

    public int getInt(int var1, int var2);

    public long getLong(int var1, int var2);

    public float getFloat(int var1, int var2);

    public double getDouble(int var1, int var2);

    public String getString(int var1, int var2);

    public ByteArray getBytes(int var1, int var2);

    public <T> T getObject(int var1, int var2);

    public int[] getIntArray(int var1, int var2);

    public long[] getLongArray(int var1, int var2);

    public float[] getFloatArray(int var1, int var2);

    public double[] getDoubleArray(int var1, int var2);

    public String[] getStringArray(int var1, int var2);

    public DataTable toMetadataOnlyDataTable();

    public DataTable toDataOnlyDataTable();

    public static enum MetadataKey {
        UNKNOWN("unknown", MetadataValueType.STRING),
        TABLE("table", MetadataValueType.STRING),
        NUM_DOCS_SCANNED("numDocsScanned", MetadataValueType.LONG),
        NUM_ENTRIES_SCANNED_IN_FILTER("numEntriesScannedInFilter", MetadataValueType.LONG),
        NUM_ENTRIES_SCANNED_POST_FILTER("numEntriesScannedPostFilter", MetadataValueType.LONG),
        NUM_SEGMENTS_QUERIED("numSegmentsQueried", MetadataValueType.INT),
        NUM_SEGMENTS_PROCESSED("numSegmentsProcessed", MetadataValueType.INT),
        NUM_SEGMENTS_MATCHED("numSegmentsMatched", MetadataValueType.INT),
        NUM_CONSUMING_SEGMENTS_PROCESSED("numConsumingSegmentsProcessed", MetadataValueType.INT),
        MIN_CONSUMING_FRESHNESS_TIME_MS("minConsumingFreshnessTimeMs", MetadataValueType.LONG),
        TOTAL_DOCS("totalDocs", MetadataValueType.LONG),
        NUM_GROUPS_LIMIT_REACHED("numGroupsLimitReached", MetadataValueType.STRING),
        TIME_USED_MS("timeUsedMs", MetadataValueType.LONG),
        TRACE_INFO("traceInfo", MetadataValueType.STRING),
        REQUEST_ID("requestId", MetadataValueType.LONG),
        NUM_RESIZES("numResizes", MetadataValueType.INT),
        RESIZE_TIME_MS("resizeTimeMs", MetadataValueType.LONG),
        THREAD_CPU_TIME_NS("threadCpuTimeNs", MetadataValueType.LONG),
        SYSTEM_ACTIVITIES_CPU_TIME_NS("systemActivitiesCpuTimeNs", MetadataValueType.LONG),
        RESPONSE_SER_CPU_TIME_NS("responseSerializationCpuTimeNs", MetadataValueType.LONG);

        private static final Map<String, MetadataKey> NAME_TO_ENUM_KEY_MAP;
        private final String _name;
        private final MetadataValueType _valueType;

        private MetadataKey(String name, MetadataValueType valueType) {
            this._name = name;
            this._valueType = valueType;
        }

        @Nullable
        public static MetadataKey getByOrdinal(int ordinal) {
            if (ordinal >= MetadataKey.values().length) {
                return null;
            }
            return MetadataKey.values()[ordinal];
        }

        public static MetadataKey getByName(String name) {
            return NAME_TO_ENUM_KEY_MAP.getOrDefault(name, null);
        }

        public String getName() {
            return this._name;
        }

        public MetadataValueType getValueType() {
            return this._valueType;
        }

        static {
            NAME_TO_ENUM_KEY_MAP = new HashMap<String, MetadataKey>();
            for (MetadataKey key : MetadataKey.values()) {
                if (NAME_TO_ENUM_KEY_MAP.put(key.getName(), key) == null) continue;
                throw new IllegalArgumentException("Duplicate name defined in the MetadataKey definition: " + key.getName());
            }
        }
    }

    public static enum MetadataValueType {
        INT,
        LONG,
        STRING;

    }
}

