/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.pinot.common.utils.SegmentName;

public class HLCSegmentName
extends SegmentName {
    private final boolean _isOldStyleNaming;
    private final String _groupId;
    private final String _sequenceNumber;
    private final String _partitionRange;
    private final String _segmentName;
    private final SegmentName.RealtimeSegmentType _segmentType;
    private final String _tableName;

    public HLCSegmentName(String segmentName) {
        if (!HLCSegmentName.isHighLevelConsumerSegmentName(segmentName)) {
            throw new RuntimeException(segmentName + " is not a HighLevelConsumer segment name");
        }
        String[] parts = segmentName.split("__");
        if (parts.length == 5) {
            this._isOldStyleNaming = true;
        } else if (parts.length == 3) {
            this._isOldStyleNaming = false;
        } else {
            throw new RuntimeException(segmentName + " is not HighLevelConsumer segment name ");
        }
        if (this.isOldStyleNaming()) {
            this._tableName = parts[0];
            this._groupId = parts[2];
            this._partitionRange = parts[3];
            this._sequenceNumber = parts[4];
            this._segmentType = SegmentName.RealtimeSegmentType.HLC_LONG;
        } else {
            this._groupId = parts[0];
            this._partitionRange = parts[1];
            this._sequenceNumber = parts[2];
            this._tableName = this._groupId.substring(0, this._groupId.indexOf("_REALTIME") + REALTIME_SUFFIX_LENGTH);
            this._segmentType = SegmentName.RealtimeSegmentType.HLC_SHORT;
        }
        this._segmentName = segmentName;
    }

    public HLCSegmentName(String groupId, String partitionRange, String sequenceNumber) {
        if (!(this.isValidComponentName(groupId) && this.isValidComponentName(partitionRange) && this.isValidComponentName(sequenceNumber))) {
            throw new IllegalArgumentException("Invalid group id (" + groupId + "), partition range (" + partitionRange + ") or sequence number (" + sequenceNumber + ")");
        }
        this._isOldStyleNaming = false;
        this._groupId = groupId;
        this._partitionRange = partitionRange;
        this._sequenceNumber = sequenceNumber;
        this._segmentName = StringUtils.join((Collection)Lists.newArrayList((Object[])new String[]{groupId, partitionRange, sequenceNumber}), (String)"__");
        this._tableName = this._groupId.substring(0, this._groupId.indexOf("_REALTIME") + REALTIME_SUFFIX_LENGTH);
        this._segmentType = SegmentName.RealtimeSegmentType.HLC_SHORT;
    }

    public boolean isOldStyleNaming() {
        return this._isOldStyleNaming;
    }

    @Override
    public String getGroupId() {
        return this._groupId;
    }

    @Override
    public String getSequenceNumberStr() {
        return this._sequenceNumber;
    }

    @Override
    public int getSequenceNumber() {
        return Integer.valueOf(this._sequenceNumber);
    }

    @Override
    public String getPartitionRange() {
        return this._partitionRange;
    }

    @Override
    public String getSegmentName() {
        return this._segmentName;
    }

    @Override
    public String getTableName() {
        return this._tableName;
    }

    @Override
    public SegmentName.RealtimeSegmentType getSegmentType() {
        return this._segmentType;
    }

    public String toString() {
        return this.getSegmentName();
    }
}

