/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.config.Lex;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.babel.SqlBabelParserImpl;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.sql.parsers.CalciteSqlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlResultComparator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlResultComparator.class);
    private static final String FIELD_RESULT_TABLE = "resultTable";
    private static final String FIELD_DATA_SCHEMA = "dataSchema";
    private static final String FIELD_COLUMN_NAMES = "columnNames";
    private static final String FIELD_COLUMN_DATA_TYPES = "columnDataTypes";
    private static final String FIELD_ROWS = "rows";
    private static final String FIELD_IS_SUPERSET = "isSuperset";
    private static final String FIELD_NUM_DOCS_SCANNED = "numDocsScanned";
    private static final String FIELD_EXCEPTIONS = "exceptions";
    private static final String FIELD_NUM_SERVERS_QUERIED = "numServersQueried";
    private static final String FIELD_NUM_SERVERS_RESPONDED = "numServersResponded";
    private static final String FIELD_NUM_SEGMENTS_QUERIED = "numSegmentsQueried";
    private static final String FIELD_NUM_SEGMENTS_PROCESSED = "numSegmentsProcessed";
    private static final String FIELD_NUM_SEGMENTS_MATCHED = "numSegmentsMatched";
    private static final String FIELD_NUM_CONSUMING_SEGMENTS_QUERIED = "numConsumingSegmentsQueried";
    private static final String FIELD_NUM_ENTRIES_SCANNED_IN_FILTER = "numEntriesScannedInFilter";
    private static final String FIELD_NUM_ENTRIES_SCANNED_POST_FILTER = "numEntriesScannedPostFilter";
    private static final String FIELD_NUM_GROUPS_LIMIT_REACHED = "numGroupsLimitReached";
    private static final String FIELD_TYPE_INT = "INT";
    private static final String FIELD_TYPE_LONG = "LONG";
    private static final String FIELD_TYPE_FLOAT = "FLOAT";
    private static final String FIELD_TYPE_DOUBLE = "DOUBLE";
    private static final String FIELD_TYPE_STRING = "STRING";
    private static final String FIELD_TYPE_BYTES = "BYTES";
    private static final String FIELD_TYPE_INT_ARRAY = "INT_ARRAY";
    private static final String FIELD_TYPE_LONG_ARRAY = "LONG_ARRAY";
    private static final String FIELD_TYPE_FLOAT_ARRAY = "FLOAT_ARRAY";
    private static final String FIELD_TYPE_DOUBLE_ARRAY = "DOUBLE_ARRAY";
    private static final String FIELD_TYPE_STRING_ARRAY = "STRING_ARRAY";
    private static final String FIELD_TYPE_BYTES_ARRRAY = "BYTES_ARRRAY";
    private static final SqlParser.Config SQL_PARSER_CONFIG = SqlParser.configBuilder().setLex(Lex.MYSQL_ANSI).setConformance((SqlConformance)SqlConformanceEnum.BABEL).setParserFactory(SqlBabelParserImpl.FACTORY).build();

    private SqlResultComparator() {
    }

    public static boolean areEqual(JsonNode actual, JsonNode expected, String query) throws IOException {
        int i;
        if (SqlResultComparator.hasExceptions(actual)) {
            return false;
        }
        if (SqlResultComparator.areEmpty(actual, expected)) {
            return true;
        }
        if (!SqlResultComparator.areDataSchemaEqual(actual, expected)) {
            return false;
        }
        ArrayNode actualRows = (ArrayNode)actual.get(FIELD_RESULT_TABLE).get(FIELD_ROWS);
        ArrayNode expectedRows = (ArrayNode)expected.get(FIELD_RESULT_TABLE).get(FIELD_ROWS);
        ArrayNode columnDataTypes = (ArrayNode)expected.get(FIELD_RESULT_TABLE).get(FIELD_DATA_SCHEMA).get(FIELD_COLUMN_DATA_TYPES);
        SqlResultComparator.convertNumbersToString(expectedRows, columnDataTypes);
        SqlResultComparator.convertNumbersToString(actualRows, columnDataTypes);
        ArrayList<String> actualElementsSerialized = new ArrayList<String>();
        ArrayList<String> expectedElementsSerialized = new ArrayList<String>();
        for (i = 0; i < actualRows.size(); ++i) {
            actualElementsSerialized.add(actualRows.get(i).toString());
        }
        for (i = 0; i < expectedRows.size(); ++i) {
            expectedElementsSerialized.add(expectedRows.get(i).toString());
        }
        if (expected.has(FIELD_IS_SUPERSET) && expected.get(FIELD_IS_SUPERSET).asBoolean(false)) {
            return SqlResultComparator.areElementsSubset(actualElementsSerialized, expectedElementsSerialized);
        }
        if (!SqlResultComparator.areLengthsEqual(actual, expected)) {
            return false;
        }
        if (!SqlResultComparator.isSelectionQuery(query) && !SqlResultComparator.areNumDocsScannedEqual(actual, expected)) {
            return false;
        }
        return SqlResultComparator.isOrderByQuery(query) ? SqlResultComparator.areOrderByQueryElementsEqual(actualRows, expectedRows, actualElementsSerialized, expectedElementsSerialized, query) : SqlResultComparator.areNonOrderByQueryElementsEqual(actualElementsSerialized, expectedElementsSerialized);
    }

    private static boolean areOrderByQueryElementsEqual(ArrayNode actualElements, ArrayNode expectedElements, List<String> actualElementsSerialized, List<String> expectedElementsSerialized, String query) {
        Object actualOtherColumnValues;
        if (actualElementsSerialized.equals(expectedElementsSerialized)) {
            LOGGER.debug("The results of the ordered query match exactly!");
            return true;
        }
        List<Integer> orderByColumnIndexs = SqlResultComparator.getOrderByColumnIndexs(query);
        LinkedHashMap<String, List> actualOrderByColumnValuesToOtherColumnValuesMap = new LinkedHashMap<String, List>();
        LinkedHashMap<String, List> expectedOrderByColumnValuesToOtherColumnValuesMap = new LinkedHashMap<String, List>();
        String lastGroupOrderByColumnValues = "";
        for (int i = 0; i < actualElements.size(); ++i) {
            String actualOrderByColumnValues = "";
            String expectedOrderByColumnValues = "";
            actualOtherColumnValues = "";
            String expectOtherColumnValues = "";
            ArrayNode actualValue = (ArrayNode)actualElements.get(i);
            ArrayNode expectedValue = (ArrayNode)expectedElements.get(i);
            for (int j = 0; j < actualValue.size(); ++j) {
                if (orderByColumnIndexs.contains(j)) {
                    actualOrderByColumnValues = actualOrderByColumnValues + ", " + actualValue.get(j).toString();
                    expectedOrderByColumnValues = expectedOrderByColumnValues + ", " + expectedValue.get(j).toString();
                    continue;
                }
                actualOtherColumnValues = (String)actualOtherColumnValues + ", " + actualValue.get(j).toString();
                expectOtherColumnValues = expectOtherColumnValues + ", " + expectedValue.get(j).toString();
            }
            lastGroupOrderByColumnValues = actualOrderByColumnValues;
            actualOrderByColumnValuesToOtherColumnValuesMap.computeIfAbsent(actualOrderByColumnValues, k -> new LinkedList()).add(actualOtherColumnValues);
            expectedOrderByColumnValuesToOtherColumnValuesMap.computeIfAbsent(expectedOrderByColumnValues, k -> new LinkedList()).add(expectOtherColumnValues);
        }
        if (!actualOrderByColumnValuesToOtherColumnValuesMap.keySet().equals(expectedOrderByColumnValuesToOtherColumnValuesMap.keySet())) {
            LOGGER.error("The results of the ordered query has different groups, actual: {}, expected: {}", actualOrderByColumnValuesToOtherColumnValuesMap.keySet(), expectedOrderByColumnValuesToOtherColumnValuesMap.keySet());
            return false;
        }
        for (Map.Entry entry : actualOrderByColumnValuesToOtherColumnValuesMap.entrySet()) {
            String orderByColumnValues = (String)entry.getKey();
            if (orderByColumnValues.equals(lastGroupOrderByColumnValues)) continue;
            actualOtherColumnValues = (List)entry.getValue();
            List expectedOtherColumnValues = (List)expectedOrderByColumnValuesToOtherColumnValuesMap.get(orderByColumnValues);
            Collections.sort(actualOtherColumnValues);
            Collections.sort(expectedOtherColumnValues);
            if (actualOtherColumnValues.equals(expectedOtherColumnValues)) continue;
            LOGGER.error("The results of the ordered query has different non-order-by column values for group: {}, actual: {}, expected: {}", new Object[]{orderByColumnValues, actualOtherColumnValues, expectedOtherColumnValues});
            return false;
        }
        return true;
    }

    private static boolean areNonOrderByQueryElementsEqual(List<String> actualElementsSerialized, List<String> expectedElementsSerialized) {
        actualElementsSerialized.sort(null);
        expectedElementsSerialized.sort(null);
        if (!actualElementsSerialized.equals(expectedElementsSerialized)) {
            LOGGER.error("The results of the non-ordered query don't match. Sorted-expected: '{}', sorted-actual: '{}'", expectedElementsSerialized, actualElementsSerialized);
            return false;
        }
        return true;
    }

    public static boolean hasExceptions(JsonNode actual) {
        if (!actual.get(FIELD_EXCEPTIONS).isEmpty()) {
            LOGGER.error("Got exception: {} when querying!", (Object)actual.get(FIELD_EXCEPTIONS));
            return true;
        }
        return false;
    }

    public static boolean areMetadataEqual(JsonNode actual, JsonNode expected) {
        return SqlResultComparator.areNumServersQueriedEqual(actual, expected) && SqlResultComparator.areNumServersRespondedEqual(actual, expected);
    }

    private static boolean areNumGroupsLimitReachedEqual(JsonNode actual, JsonNode expected) {
        boolean expectedNumGroupsLimitReached;
        boolean actualNumGroupsLimitReached = actual.get(FIELD_NUM_GROUPS_LIMIT_REACHED).asBoolean();
        if (actualNumGroupsLimitReached != (expectedNumGroupsLimitReached = expected.get(FIELD_NUM_GROUPS_LIMIT_REACHED).asBoolean())) {
            LOGGER.error("The numGroupsLimitReached don't match! Actual: {}, Expected: {}", (Object)actualNumGroupsLimitReached, (Object)expectedNumGroupsLimitReached);
            return false;
        }
        return true;
    }

    private static boolean areNumConsumingSegmentsQueriedEqual(JsonNode actual, JsonNode expected) {
        long expectedNumConsumingSegmentsQueried;
        long actualNumConsumingSegmentsQueried = actual.get(FIELD_NUM_CONSUMING_SEGMENTS_QUERIED).asLong();
        if (actualNumConsumingSegmentsQueried != (expectedNumConsumingSegmentsQueried = expected.get(FIELD_NUM_CONSUMING_SEGMENTS_QUERIED).asLong())) {
            LOGGER.error("The numConsumingSegmentsQueried don't match! Actual: {}, Expected: {}", (Object)actualNumConsumingSegmentsQueried, (Object)expectedNumConsumingSegmentsQueried);
            return false;
        }
        return true;
    }

    private static boolean areNumSegmentsProcessedEqual(JsonNode actual, JsonNode expected) {
        long expectedNumSegmentsProcessed;
        long actualNumSegmentsProcessed = actual.get(FIELD_NUM_SEGMENTS_PROCESSED).asLong();
        if (actualNumSegmentsProcessed != (expectedNumSegmentsProcessed = expected.get(FIELD_NUM_SEGMENTS_PROCESSED).asLong())) {
            LOGGER.error("The numSegmentsProcessed don't match! Actual: {}, Expected: {}", (Object)actualNumSegmentsProcessed, (Object)expectedNumSegmentsProcessed);
            return false;
        }
        return true;
    }

    private static boolean areNumSegmentsQueriedEqual(JsonNode actual, JsonNode expected) {
        long expectedNumSegmentsQueried;
        long actualNumSegmentsQueried = actual.get(FIELD_NUM_SEGMENTS_QUERIED).asLong();
        if (actualNumSegmentsQueried != (expectedNumSegmentsQueried = expected.get(FIELD_NUM_SEGMENTS_QUERIED).asLong())) {
            LOGGER.error("The numSegmentsQueried don't match! Actual: {}, Expected: {}", (Object)actualNumSegmentsQueried, (Object)expectedNumSegmentsQueried);
            return false;
        }
        return true;
    }

    private static boolean areNumSegmentsMatchedEqual(JsonNode actual, JsonNode expected) {
        long expectedNumSegmentsMatched;
        long actualNumSegmentsMatched = actual.get(FIELD_NUM_SEGMENTS_MATCHED).asLong();
        if (actualNumSegmentsMatched != (expectedNumSegmentsMatched = expected.get(FIELD_NUM_SEGMENTS_MATCHED).asLong())) {
            LOGGER.error("The numSegmentsMatched don't match! Actual: {}, Expected: {}", (Object)actualNumSegmentsMatched, (Object)expectedNumSegmentsMatched);
            return false;
        }
        return true;
    }

    private static boolean areNumServersRespondedEqual(JsonNode actual, JsonNode expected) {
        long expectedNumServersResponded;
        long actualNumServersResponded = actual.get(FIELD_NUM_SERVERS_RESPONDED).asLong();
        if (actualNumServersResponded != (expectedNumServersResponded = expected.get(FIELD_NUM_SERVERS_RESPONDED).asLong())) {
            LOGGER.error("The numServersResponded don't match! Actual: {}, Expected: {}", (Object)actualNumServersResponded, (Object)expectedNumServersResponded);
            return false;
        }
        return true;
    }

    private static boolean areNumServersQueriedEqual(JsonNode actual, JsonNode expected) {
        long expectedNumServersQueried;
        long actualNumServersQueried = actual.get(FIELD_NUM_SERVERS_QUERIED).asLong();
        if (actualNumServersQueried != (expectedNumServersQueried = expected.get(FIELD_NUM_SERVERS_QUERIED).asLong())) {
            LOGGER.error("The numServersQueried don't match! Actual: {}, Expected: {}", (Object)actualNumServersQueried, (Object)expectedNumServersQueried);
            return false;
        }
        return true;
    }

    private static boolean areNumEntriesScannedInFilterEqual(JsonNode actual, JsonNode expected) {
        long expectedNumEntriesScannedInFilter;
        long actualNumEntriesScannedInFilter = actual.get(FIELD_NUM_ENTRIES_SCANNED_IN_FILTER).asLong();
        if (actualNumEntriesScannedInFilter != (expectedNumEntriesScannedInFilter = expected.get(FIELD_NUM_ENTRIES_SCANNED_IN_FILTER).asLong())) {
            LOGGER.error("The numEntriesScannedInFilter don't match! Actual: {}, Expected: {}", (Object)actualNumEntriesScannedInFilter, (Object)expectedNumEntriesScannedInFilter);
            return false;
        }
        return true;
    }

    private static boolean areNumEntriesScannedPostFilterEqual(JsonNode actual, JsonNode expected) {
        long expectedNumEntriesScannedPostFilter;
        long actualNumEntriesScannedPostFilter = actual.get(FIELD_NUM_ENTRIES_SCANNED_POST_FILTER).asLong();
        if (actualNumEntriesScannedPostFilter != (expectedNumEntriesScannedPostFilter = expected.get(FIELD_NUM_ENTRIES_SCANNED_POST_FILTER).asLong())) {
            LOGGER.error("The numEntriesScannedPostFilter don't match! Actual: {}, Expected: {}", (Object)actualNumEntriesScannedPostFilter, (Object)expectedNumEntriesScannedPostFilter);
            return false;
        }
        return true;
    }

    private static boolean areNumDocsScannedEqual(JsonNode actual, JsonNode expected) {
        int expectedNumDocsScanned;
        int actualNumDocsScanned = actual.get(FIELD_NUM_DOCS_SCANNED).asInt();
        if (actualNumDocsScanned != (expectedNumDocsScanned = expected.get(FIELD_NUM_DOCS_SCANNED).asInt())) {
            LOGGER.error("The numDocsScanned don't match! Actual: {}, Expected: {}", (Object)actualNumDocsScanned, (Object)expectedNumDocsScanned);
            return false;
        }
        return true;
    }

    private static boolean areEmpty(JsonNode actual, JsonNode expected) {
        if (SqlResultComparator.isEmpty(actual) && SqlResultComparator.isEmpty(expected)) {
            LOGGER.debug("Empty results, nothing to compare.");
            return true;
        }
        return false;
    }

    public static boolean isEmpty(JsonNode response) {
        int numDocsScanned = response.get(FIELD_NUM_DOCS_SCANNED).asInt();
        return numDocsScanned == 0 || !response.has(FIELD_RESULT_TABLE) || response.get(FIELD_RESULT_TABLE).get(FIELD_ROWS).isEmpty();
    }

    private static boolean areLengthsEqual(JsonNode actual, JsonNode expected) {
        int expectedLength;
        int actualLength = actual.get(FIELD_RESULT_TABLE).get(FIELD_ROWS).size();
        if (actualLength != (expectedLength = expected.get(FIELD_RESULT_TABLE).get(FIELD_ROWS).size())) {
            LOGGER.error("The length of results don't match! Actual: {}, Expected: {}", (Object)actualLength, (Object)expectedLength);
            return false;
        }
        return true;
    }

    private static boolean areDataSchemaEqual(JsonNode actual, JsonNode expected) {
        String expectedDataSchemaStr;
        JsonNode actualColumnNames = actual.get(FIELD_RESULT_TABLE).get(FIELD_DATA_SCHEMA).get(FIELD_COLUMN_NAMES);
        JsonNode expectedColumnNames = expected.get(FIELD_RESULT_TABLE).get(FIELD_DATA_SCHEMA).get(FIELD_COLUMN_NAMES);
        JsonNode actualColumnDataTypes = actual.get(FIELD_RESULT_TABLE).get(FIELD_DATA_SCHEMA).get(FIELD_COLUMN_DATA_TYPES);
        JsonNode expectedColumnDataTypes = expected.get(FIELD_RESULT_TABLE).get(FIELD_DATA_SCHEMA).get(FIELD_COLUMN_DATA_TYPES);
        String actualDataSchemaStr = actualColumnNames.toString() + actualColumnDataTypes.toString();
        if (!actualDataSchemaStr.equals(expectedDataSchemaStr = expectedColumnNames.toString() + expectedColumnDataTypes.toString())) {
            LOGGER.error("The dataSchema don't match! Actual: {}, Expected: {}", (Object)actualDataSchemaStr, (Object)expectedDataSchemaStr);
            return false;
        }
        return true;
    }

    private static boolean areElementsSubset(List<String> actualElementsSerialized, List<String> expectedElementsSerialized) {
        boolean result = expectedElementsSerialized.containsAll(actualElementsSerialized);
        if (!result) {
            LOGGER.error("Actual result '{}' is not a subset of '{}'", actualElementsSerialized, expectedElementsSerialized);
        }
        return result;
    }

    private static void convertNumbersToString(ArrayNode rows, ArrayNode columnDataTypes) throws IOException {
        for (int i = 0; i < rows.size(); ++i) {
            for (int j = 0; j < columnDataTypes.size(); ++j) {
                ArrayNode row = (ArrayNode)rows.get(i);
                String type = columnDataTypes.get(j).asText();
                if (type.equals(FIELD_TYPE_FLOAT) || type.equals(FIELD_TYPE_DOUBLE)) {
                    double round = (double)Math.round(Double.valueOf(row.get(j).asText()) * 100.0) / 100.0;
                    String str = String.valueOf(round);
                    row.set(j, JsonUtils.stringToJsonNode((String)str));
                    continue;
                }
                if (!type.equals(FIELD_TYPE_FLOAT_ARRAY) && !type.equals(FIELD_TYPE_DOUBLE_ARRAY)) continue;
                ArrayNode jsonArray = (ArrayNode)rows.get(i).get(j);
                ArrayList<String> arrayStr = new ArrayList<String>();
                for (int k = 0; k < jsonArray.size(); ++k) {
                    double round = Math.round(Double.valueOf(jsonArray.get(k).asText()) * 100.0) / 100L;
                    arrayStr.add(String.valueOf(round));
                }
                row.set(j, JsonUtils.stringToJsonNode((String)((Object)arrayStr).toString()));
            }
        }
    }

    private static boolean isOrderByQuery(String query) {
        SqlParser sqlParser = SqlParser.create((String)query, (SqlParser.Config)SQL_PARSER_CONFIG);
        try {
            boolean isOrderBy;
            SqlNode sqlNode = sqlParser.parseQuery();
            boolean bl = isOrderBy = sqlNode.getKind() == SqlKind.ORDER_BY;
            if (!isOrderBy) {
                return false;
            }
            SqlOrderBy sqlOrderBy = (SqlOrderBy)sqlNode;
            SqlNodeList orderByColumns = sqlOrderBy.orderList;
            return orderByColumns != null && orderByColumns.size() != 0;
        }
        catch (SqlParseException e) {
            throw new RuntimeException("Cannot parse query: " + query, e);
        }
    }

    private static boolean isSelectionQuery(String query) {
        PinotQuery pinotQuery = CalciteSqlParser.compileToPinotQuery(query);
        if (pinotQuery.getSelectList() == null) {
            return false;
        }
        if (pinotQuery.isSetGroupByList()) {
            return false;
        }
        for (Expression expression : pinotQuery.getSelectList()) {
            Function functionCall;
            String functionName;
            if (expression.getType() != ExpressionType.FUNCTION || !AggregationFunctionType.isAggregationFunction((String)(functionName = (functionCall = expression.getFunctionCall()).getOperator()))) continue;
            return false;
        }
        return true;
    }

    private static List<Integer> getOrderByColumnIndexs(String query) {
        SqlSelect selectNodeWithOrderBy = SqlResultComparator.getSelectNodeWithOrderBy(query);
        SqlNodeList selectList = selectNodeWithOrderBy.getSelectList();
        ArrayList<String> selectColumnNames = new ArrayList<String>();
        for (SqlNode node : selectList) {
            selectColumnNames.add(node.toString());
        }
        SqlNodeList orderList = selectNodeWithOrderBy.getOrderList();
        ArrayList<String> orderByColumnNames = new ArrayList<String>();
        for (SqlNode node : orderList) {
            String columnName = node instanceof SqlCall ? ((SqlNode)((SqlCall)node).getOperandList().get(0)).toString() : node.toString();
            orderByColumnNames.add(columnName);
        }
        LinkedList<Integer> orderByColumnIndexs = new LinkedList<Integer>();
        int j = 0;
        for (int i = 0; i < orderByColumnNames.size(); ++i) {
            while (j < selectColumnNames.size() && !((String)selectColumnNames.get(j)).equals(orderByColumnNames.get(i))) {
                ++j;
            }
            orderByColumnIndexs.add(j);
        }
        return orderByColumnIndexs;
    }

    private static SqlSelect getSelectNodeWithOrderBy(String query) {
        SqlParser sqlParser = SqlParser.create((String)query, (SqlParser.Config)SQL_PARSER_CONFIG);
        try {
            SqlSelect selectNode;
            SqlNode sqlNode = sqlParser.parseQuery();
            if (sqlNode instanceof SqlOrderBy) {
                SqlOrderBy orderByNode = (SqlOrderBy)sqlNode;
                selectNode = (SqlSelect)orderByNode.query;
                selectNode.setOrderBy(orderByNode.orderList);
                selectNode.setFetch(orderByNode.fetch);
                selectNode.setOffset(orderByNode.offset);
            } else {
                selectNode = (SqlSelect)sqlNode;
            }
            return selectNode;
        }
        catch (SqlParseException e) {
            throw new RuntimeException("Cannot parse query: " + query, e);
        }
    }
}

