/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.pinot.common.config.TlsConfig;
import org.apache.pinot.common.utils.FileUploadDownloadClient;
import org.apache.pinot.spi.env.PinotConfiguration;

public final class TlsUtils {
    private static final String CLIENT_AUTH_ENABLED = "client.auth.enabled";
    private static final String KEYSTORE_TYPE = "keystore.type";
    private static final String KEYSTORE_PATH = "keystore.path";
    private static final String KEYSTORE_PASSWORD = "keystore.password";
    private static final String TRUSTSTORE_TYPE = "truststore.type";
    private static final String TRUSTSTORE_PATH = "truststore.path";
    private static final String TRUSTSTORE_PASSWORD = "truststore.password";
    private static final String SSL_PROVIDER = "ssl.provider";

    private TlsUtils() {
    }

    public static TlsConfig extractTlsConfig(PinotConfiguration pinotConfig, String namespace) {
        return TlsUtils.extractTlsConfig(pinotConfig, namespace, new TlsConfig());
    }

    public static TlsConfig extractTlsConfig(PinotConfiguration pinotConfig, String namespace, TlsConfig defaultConfig) {
        TlsConfig tlsConfig = new TlsConfig(defaultConfig);
        tlsConfig.setClientAuthEnabled(pinotConfig.getProperty(TlsUtils.key(namespace, CLIENT_AUTH_ENABLED), defaultConfig.isClientAuthEnabled()));
        tlsConfig.setKeyStoreType(pinotConfig.getProperty(TlsUtils.key(namespace, KEYSTORE_TYPE), defaultConfig.getKeyStoreType()));
        tlsConfig.setKeyStorePath(pinotConfig.getProperty(TlsUtils.key(namespace, KEYSTORE_PATH), defaultConfig.getKeyStorePath()));
        tlsConfig.setKeyStorePassword(pinotConfig.getProperty(TlsUtils.key(namespace, KEYSTORE_PASSWORD), defaultConfig.getKeyStorePassword()));
        tlsConfig.setTrustStoreType(pinotConfig.getProperty(TlsUtils.key(namespace, TRUSTSTORE_TYPE), defaultConfig.getTrustStoreType()));
        tlsConfig.setTrustStorePath(pinotConfig.getProperty(TlsUtils.key(namespace, TRUSTSTORE_PATH), defaultConfig.getTrustStorePath()));
        tlsConfig.setTrustStorePassword(pinotConfig.getProperty(TlsUtils.key(namespace, TRUSTSTORE_PASSWORD), defaultConfig.getTrustStorePassword()));
        tlsConfig.setSslProvider(pinotConfig.getProperty(TlsUtils.key(namespace, SSL_PROVIDER), defaultConfig.getSslProvider()));
        return tlsConfig;
    }

    public static KeyManagerFactory createKeyManagerFactory(TlsConfig tlsConfig) {
        return TlsUtils.createKeyManagerFactory(tlsConfig.getKeyStorePath(), tlsConfig.getKeyStorePassword(), tlsConfig.getKeyStoreType());
    }

    public static KeyManagerFactory createKeyManagerFactory(String keyStorePath, String keyStorePassword, String keyStoreType) {
        Preconditions.checkNotNull((Object)keyStorePath, (Object)"key store path must not be null");
        Preconditions.checkNotNull((Object)keyStorePassword, (Object)"key store password must not be null");
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            try (InputStream is = TlsUtils.makeKeyStoreUrl(keyStorePath).openStream();){
                keyStore.load(is, keyStorePassword.toCharArray());
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
            return keyManagerFactory;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not create key manager factory '%s'", keyStorePath), e);
        }
    }

    public static TrustManagerFactory createTrustManagerFactory(TlsConfig tlsConfig) {
        return TlsUtils.createTrustManagerFactory(tlsConfig.getTrustStorePath(), tlsConfig.getTrustStorePassword(), tlsConfig.getTrustStoreType());
    }

    public static TrustManagerFactory createTrustManagerFactory(String trustStorePath, String trustStorePassword, String trustStoreType) {
        Preconditions.checkNotNull((Object)trustStorePath, (Object)"trust store path must not be null");
        Preconditions.checkNotNull((Object)trustStorePassword, (Object)"trust store password must not be null");
        try {
            KeyStore keyStore = KeyStore.getInstance(trustStoreType);
            try (InputStream is = TlsUtils.makeKeyStoreUrl(trustStorePath).openStream();){
                keyStore.load(is, trustStorePassword.toCharArray());
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            return trustManagerFactory;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not create trust manager factory '%s'", trustStorePath), e);
        }
    }

    public static void installDefaultSSLSocketFactory(TlsConfig tlsConfig) {
        TlsUtils.installDefaultSSLSocketFactory(tlsConfig.getKeyStoreType(), tlsConfig.getKeyStorePath(), tlsConfig.getKeyStorePassword(), tlsConfig.getTrustStoreType(), tlsConfig.getTrustStorePath(), tlsConfig.getTrustStorePassword());
    }

    public static void installDefaultSSLSocketFactory(String keyStoreType, String keyStorePath, String keyStorePassword, String trustStoreType, String trustStorePath, String trustStorePassword) {
        KeyManager[] keyManagers = null;
        if (keyStorePath != null) {
            keyManagers = TlsUtils.createKeyManagerFactory(keyStorePath, keyStorePassword, keyStoreType).getKeyManagers();
        }
        TrustManager[] trustManagers = null;
        if (trustStorePath != null) {
            trustManagers = TlsUtils.createTrustManagerFactory(trustStorePath, trustStorePassword, trustStoreType).getTrustManagers();
        }
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(keyManagers, trustManagers, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new PinotProtocolSocketFactory(sc.getSocketFactory()), 443));
            FileUploadDownloadClient.installDefaultSSLContext(sc);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Could not initialize SSL support", e);
        }
    }

    private static String key(String namespace, String suffix) {
        return namespace + "." + suffix;
    }

    public static URL makeKeyStoreUrl(String storePath) throws URISyntaxException, MalformedURLException {
        URI inputUri = new URI(storePath);
        if (StringUtils.isBlank((String)inputUri.getScheme())) {
            if (storePath.startsWith("/")) {
                return new URL("file://" + storePath);
            }
            return new URL("file://./" + storePath);
        }
        return inputUri.toURL();
    }

    private static class PinotProtocolSocketFactory
    implements ProtocolSocketFactory {
        final SSLSocketFactory _sslSocketFactory;

        public PinotProtocolSocketFactory(SSLSocketFactory sslSocketFactory) {
            this._sslSocketFactory = sslSocketFactory;
        }

        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
            return this._sslSocketFactory.createSocket(host, port, localAddress, localPort);
        }

        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException {
            Preconditions.checkNotNull((Object)params);
            int timeout = params.getConnectionTimeout();
            if (timeout <= 0) {
                return this._sslSocketFactory.createSocket(host, port, localAddress, localPort);
            }
            Socket socket = this._sslSocketFactory.createSocket();
            InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
            InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
            socket.bind(localaddr);
            socket.connect(remoteaddr, timeout);
            return socket;
        }

        public Socket createSocket(String host, int port) throws IOException {
            return this._sslSocketFactory.createSocket(host, port);
        }
    }
}

