/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.pql.parsers.pql2.ast;

import java.util.HashSet;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.request.SelectionSort;
import org.apache.pinot.common.request.transform.TransformExpressionTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.pql.parsers.pql2.ast.BaseAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.OrderByExpressionAstNode;

public class OrderByAstNode
extends BaseAstNode {
    public static final String ASCENDING_ORDER = "asc";
    public static final String DESCENDING_ORDER = "desc";

    @Override
    public void updateBrokerRequest(BrokerRequest brokerRequest) {
        HashSet<TransformExpressionTree> orderByExpressions = new HashSet<TransformExpressionTree>();
        for (AstNode astNode : this.getChildren()) {
            if (astNode instanceof OrderByExpressionAstNode) {
                OrderByExpressionAstNode orderByExpressionAstNode = (OrderByExpressionAstNode)astNode;
                TransformExpressionTree orderByExpression = TransformExpressionTree.compileToExpressionTree(orderByExpressionAstNode.getColumn());
                if (!orderByExpressions.add(orderByExpression)) continue;
                SelectionSort selectionSort = new SelectionSort();
                selectionSort.setColumn(orderByExpression.toString());
                selectionSort.setIsAsc(orderByExpressionAstNode.getOrdering().equalsIgnoreCase(ASCENDING_ORDER));
                brokerRequest.addToOrderBy(selectionSort);
                if (brokerRequest.getSelections() == null) continue;
                brokerRequest.getSelections().addToSelectionSortSequence(selectionSort);
                continue;
            }
            throw new Pql2CompilationException("Child node of ORDER BY node is not an expression node");
        }
    }

    @Override
    public void updatePinotQuery(PinotQuery pinotQuery) {
        HashSet<TransformExpressionTree> orderByExpressions = new HashSet<TransformExpressionTree>();
        for (AstNode astNode : this.getChildren()) {
            if (astNode instanceof OrderByExpressionAstNode) {
                OrderByExpressionAstNode orderByExpressionAstNode = (OrderByExpressionAstNode)astNode;
                TransformExpressionTree orderByExpression = TransformExpressionTree.compileToExpressionTree(orderByExpressionAstNode.getColumn());
                if (!orderByExpressions.add(orderByExpression)) continue;
                String ordering = ASCENDING_ORDER.equalsIgnoreCase(orderByExpressionAstNode.getOrdering()) ? ASCENDING_ORDER : DESCENDING_ORDER;
                Expression orderByFunctionExpression = RequestUtils.getFunctionExpression(ordering);
                orderByFunctionExpression.getFunctionCall().addToOperands(RequestUtils.createIdentifierExpression(orderByExpression.toString()));
                pinotQuery.addToOrderByList(orderByFunctionExpression);
                continue;
            }
            throw new Pql2CompilationException("Child node of ORDER BY node is not an expression node");
        }
    }
}

