/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.server;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.configuration.DefunctConfig;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"jetty.http.enabled", "jetty.http.port", "jetty.https.enabled", "jetty.https.port", "jetty.https.keystore.path", "jetty.https.keystore.password", "jetty.log.path", "jetty.log.retain-days", "jetty.threads.min", "jetty.threads.max", "jetty.threads.max-idle-time-ms", "jetty.net.max-idle-time-ms", "jetty.auth.users-file", "http-server.https.keystore.password", "http-server.log.retention-time"})
public class HttpServerConfig {
    private boolean httpEnabled = true;
    private int httpPort = 8080;
    private int httpAcceptQueueSize = 8000;
    private boolean httpsEnabled;
    private String logPath = "var/log/http-request.log";
    private boolean logEnabled = true;
    private boolean requestStatsEnabled = true;
    private int logHistory = 15;
    private int logQueueSize = 10000;
    private DataSize logMaxFileSize = new DataSize(100.0, DataSize.Unit.MEGABYTE);
    private boolean logCompressionEnabled = true;
    private Integer httpAcceptorThreads;
    private Integer httpSelectorThreads;
    private Integer httpsAcceptorThreads;
    private Integer httpsSelectorThreads;
    private int minThreads = 2;
    private int maxThreads = 200;
    private Duration threadMaxIdleTime = new Duration(1.0, TimeUnit.MINUTES);
    private Duration networkMaxIdleTime = new Duration(200.0, TimeUnit.SECONDS);
    private DataSize maxRequestHeaderSize;
    private DataSize maxResponseHeaderSize;
    private int http2MaxConcurrentStreams = 16384;
    private DataSize http2InitialSessionReceiveWindowSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize http2InitialStreamReceiveWindowSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize http2InputBufferSize = new DataSize(8.0, DataSize.Unit.KILOBYTE);
    private Duration http2StreamIdleTimeout = new Duration(15.0, TimeUnit.SECONDS);
    private String userAuthFile;
    private boolean adminEnabled = true;
    private int adminPort;
    private int adminMinThreads = 2;
    private int adminMaxThreads = 200;
    private int timeoutThreads = 1;
    private int timeoutConcurrency = 1;
    private boolean showStackTrace = true;
    private boolean authorizationEnabled;
    private AuthorizationPolicy defaultAuthorizationPolicy = AuthorizationPolicy.ALLOW;
    private Set<String> defaultAllowedRoles = ImmutableSet.of();
    private boolean allowUnsecureRequestsInAuthorizer;

    public boolean isHttpEnabled() {
        return this.httpEnabled;
    }

    @Config(value="http-server.http.enabled")
    public HttpServerConfig setHttpEnabled(boolean httpEnabled) {
        this.httpEnabled = httpEnabled;
        return this;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    @Config(value="http-server.accept-queue-size")
    public HttpServerConfig setHttpAcceptQueueSize(int httpAcceptQueueSize) {
        this.httpAcceptQueueSize = httpAcceptQueueSize;
        return this;
    }

    public int getHttpAcceptQueueSize() {
        return this.httpAcceptQueueSize;
    }

    @Config(value="http-server.http.port")
    public HttpServerConfig setHttpPort(int httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    @Config(value="http-server.https.enabled")
    public HttpServerConfig setHttpsEnabled(boolean httpsEnabled) {
        this.httpsEnabled = httpsEnabled;
        return this;
    }

    public String getLogPath() {
        return this.logPath;
    }

    @Config(value="http-server.log.path")
    public HttpServerConfig setLogPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    @Config(value="http-server.log.enabled")
    public HttpServerConfig setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
        return this;
    }

    public boolean isRequestStatsEnabled() {
        return this.requestStatsEnabled;
    }

    @Config(value="http-server.request-stats.enabled")
    public HttpServerConfig setRequestStatsEnabled(boolean requestStatsEnabled) {
        this.requestStatsEnabled = requestStatsEnabled;
        return this;
    }

    public DataSize getLogMaxFileSize() {
        return this.logMaxFileSize;
    }

    @Config(value="http-server.log.max-size")
    public HttpServerConfig setLogMaxFileSize(DataSize logMaxFileSize) {
        this.logMaxFileSize = logMaxFileSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) Integer getHttpAcceptorThreads() {
        return this.httpAcceptorThreads;
    }

    @Config(value="http-server.http.acceptor-threads")
    public HttpServerConfig setHttpAcceptorThreads(Integer httpAcceptorThreads) {
        this.httpAcceptorThreads = httpAcceptorThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) Integer getHttpSelectorThreads() {
        return this.httpSelectorThreads;
    }

    @Config(value="http-server.http.selector-threads")
    public HttpServerConfig setHttpSelectorThreads(Integer httpSelectorThreads) {
        this.httpSelectorThreads = httpSelectorThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) Integer getHttpsAcceptorThreads() {
        return this.httpsAcceptorThreads;
    }

    @Config(value="http-server.https.acceptor-threads")
    public HttpServerConfig setHttpsAcceptorThreads(Integer httpsAcceptorThreads) {
        this.httpsAcceptorThreads = httpsAcceptorThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) Integer getHttpsSelectorThreads() {
        return this.httpsSelectorThreads;
    }

    @Config(value="http-server.https.selector-threads")
    public HttpServerConfig setHttpsSelectorThreads(Integer httpsSelectorThreads) {
        this.httpsSelectorThreads = httpsSelectorThreads;
        return this;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    @Config(value="http-server.threads.max")
    public HttpServerConfig setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    @Config(value="http-server.threads.min")
    public HttpServerConfig setMinThreads(int minThreads) {
        this.minThreads = minThreads;
        return this;
    }

    public Duration getThreadMaxIdleTime() {
        return this.threadMaxIdleTime;
    }

    @Config(value="http-server.threads.max-idle-time")
    public HttpServerConfig setThreadMaxIdleTime(Duration threadMaxIdleTime) {
        this.threadMaxIdleTime = threadMaxIdleTime;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getTimeoutThreads() {
        return this.timeoutThreads;
    }

    @Config(value="http-server.timeout-threads")
    public HttpServerConfig setTimeoutThreads(int timeoutThreads) {
        this.timeoutThreads = timeoutThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getTimeoutConcurrency() {
        return this.timeoutConcurrency;
    }

    @Config(value="http-server.timeout-concurrency")
    public HttpServerConfig setTimeoutConcurrency(int timeoutConcurrency) {
        this.timeoutConcurrency = timeoutConcurrency;
        return this;
    }

    public int getLogHistory() {
        return this.logHistory;
    }

    @Config(value="http-server.log.max-history")
    public HttpServerConfig setLogHistory(int logHistory) {
        this.logHistory = logHistory;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getLogQueueSize() {
        return this.logQueueSize;
    }

    @Config(value="http-server.log.queue-size")
    public HttpServerConfig setLogQueueSize(int logQueueSize) {
        this.logQueueSize = logQueueSize;
        return this;
    }

    public boolean isLogCompressionEnabled() {
        return this.logCompressionEnabled;
    }

    @Config(value="http-server.log.compression.enabled")
    public HttpServerConfig setLogCompressionEnabled(boolean logCompressionEnabled) {
        this.logCompressionEnabled = logCompressionEnabled;
        return this;
    }

    public String getUserAuthFile() {
        return this.userAuthFile;
    }

    @Config(value="http-server.auth.users-file")
    public HttpServerConfig setUserAuthFile(String userAuthFile) {
        this.userAuthFile = userAuthFile;
        return this;
    }

    public Duration getNetworkMaxIdleTime() {
        return this.networkMaxIdleTime;
    }

    @Config(value="http-server.net.max-idle-time")
    public HttpServerConfig setNetworkMaxIdleTime(Duration networkMaxIdleTime) {
        this.networkMaxIdleTime = networkMaxIdleTime;
        return this;
    }

    public boolean isAdminEnabled() {
        return this.adminEnabled;
    }

    @Config(value="http-server.admin.enabled")
    public HttpServerConfig setAdminEnabled(boolean adminEnabled) {
        this.adminEnabled = adminEnabled;
        return this;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    @Config(value="http-server.admin.port")
    public HttpServerConfig setAdminPort(int adminPort) {
        this.adminPort = adminPort;
        return this;
    }

    public int getAdminMinThreads() {
        return this.adminMinThreads;
    }

    @Config(value="http-server.admin.threads.min")
    public HttpServerConfig setAdminMinThreads(int adminMinThreads) {
        this.adminMinThreads = adminMinThreads;
        return this;
    }

    @Min(value=2L)
    public @Min(value=2L) int getAdminMaxThreads() {
        return this.adminMaxThreads;
    }

    @Config(value="http-server.admin.threads.max")
    public HttpServerConfig setAdminMaxThreads(int adminMaxThreads) {
        this.adminMaxThreads = adminMaxThreads;
        return this;
    }

    public DataSize getMaxRequestHeaderSize() {
        return this.maxRequestHeaderSize;
    }

    @Config(value="http-server.max-request-header-size")
    public HttpServerConfig setMaxRequestHeaderSize(DataSize maxRequestHeaderSize) {
        this.maxRequestHeaderSize = maxRequestHeaderSize;
        return this;
    }

    public DataSize getMaxResponseHeaderSize() {
        return this.maxResponseHeaderSize;
    }

    @Config(value="http-server.max-response-header-size")
    public HttpServerConfig setMaxResponseHeaderSize(DataSize maxResponseHeaderSize) {
        this.maxResponseHeaderSize = maxResponseHeaderSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getHttp2MaxConcurrentStreams() {
        return this.http2MaxConcurrentStreams;
    }

    @Config(value="http-server.http2.max-concurrent-streams")
    @ConfigDescription(value="Maximum concurrent streams per connection for HTTP/2")
    public HttpServerConfig setHttp2MaxConcurrentStreams(int http2MaxConcurrentStreams) {
        this.http2MaxConcurrentStreams = http2MaxConcurrentStreams;
        return this;
    }

    public boolean isShowStackTrace() {
        return this.showStackTrace;
    }

    @Config(value="http-server.show-stack-trace")
    @ConfigDescription(value="Show the stack trace when generating an error response")
    public HttpServerConfig setShowStackTrace(boolean showStackTrace) {
        this.showStackTrace = showStackTrace;
        return this;
    }

    @NotNull
    @MinDataSize(value="1kB")
    @MaxDataSize(value="1GB")
    public DataSize getHttp2InitialSessionReceiveWindowSize() {
        return this.http2InitialSessionReceiveWindowSize;
    }

    @Config(value="http-server.http2.session-receive-window-size")
    @ConfigDescription(value="Initial size of session's flow control receive window for HTTP/2")
    public HttpServerConfig setHttp2InitialSessionReceiveWindowSize(DataSize http2InitialSessionReceiveWindowSize) {
        this.http2InitialSessionReceiveWindowSize = http2InitialSessionReceiveWindowSize;
        return this;
    }

    @NotNull
    @MinDataSize(value="1kB")
    @MaxDataSize(value="1GB")
    public DataSize getHttp2InitialStreamReceiveWindowSize() {
        return this.http2InitialStreamReceiveWindowSize;
    }

    @Config(value="http-server.http2.stream-receive-window-size")
    @ConfigDescription(value="Initial size of stream's flow control receive window for HTTP/2")
    public HttpServerConfig setHttp2InitialStreamReceiveWindowSize(DataSize http2InitialStreamReceiveWindowSize) {
        this.http2InitialStreamReceiveWindowSize = http2InitialStreamReceiveWindowSize;
        return this;
    }

    @NotNull
    @MinDataSize(value="1kB")
    @MaxDataSize(value="32MB")
    public DataSize getHttp2InputBufferSize() {
        return this.http2InputBufferSize;
    }

    @Config(value="http-server.http2.input-buffer-size")
    @ConfigDescription(value="Size of the buffer used to read from the network for HTTP/2")
    public HttpServerConfig setHttp2InputBufferSize(DataSize http2InputBufferSize) {
        this.http2InputBufferSize = http2InputBufferSize;
        return this;
    }

    public Duration getHttp2StreamIdleTimeout() {
        return this.http2StreamIdleTimeout;
    }

    @Config(value="http-server.http2.stream-idle-timeout")
    public HttpServerConfig setHttp2StreamIdleTimeout(Duration http2StreamIdleTimeout) {
        this.http2StreamIdleTimeout = http2StreamIdleTimeout;
        return this;
    }

    public boolean isAuthorizationEnabled() {
        return this.authorizationEnabled;
    }

    @Config(value="http-server.authorization.enabled")
    public HttpServerConfig setAuthorizationEnabled(boolean authorizationEnabled) {
        this.authorizationEnabled = authorizationEnabled;
        return this;
    }

    @NotNull
    public AuthorizationPolicy getDefaultAuthorizationPolicy() {
        return this.defaultAuthorizationPolicy;
    }

    @Config(value="http-server.authorization.default-policy")
    @ConfigDescription(value="The default authorization policy applies to endpoints without allowed roles specified")
    public HttpServerConfig setDefaultAuthorizationPolicy(AuthorizationPolicy defaultAuthorizationPolicy) {
        this.defaultAuthorizationPolicy = Objects.requireNonNull(defaultAuthorizationPolicy, "defaultAuthorizationPolicy is null");
        return this;
    }

    public Set<String> getDefaultAllowedRoles() {
        return this.defaultAllowedRoles;
    }

    @Config(value="http-server.authorization.default-allowed-roles")
    @ConfigDescription(value="A comma-separated list of default roles allowed to access endpoints without explicitly specified roles")
    public HttpServerConfig setDefaultAllowedRoles(String defaultAllowedRoles) {
        this.defaultAllowedRoles = (Set)Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)Objects.requireNonNull(defaultAllowedRoles, "defaultAllowedRoles is null")).stream().map(role -> role.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
        return this;
    }

    public boolean isAllowUnsecureRequestsInAuthorizer() {
        return this.allowUnsecureRequestsInAuthorizer;
    }

    @Config(value="http-server.authorization.allow-unsecured-requests")
    @ConfigDescription(value="Skip authorization check for unsecured requests when this config is on")
    public HttpServerConfig setAllowUnsecureRequestsInAuthorizer(boolean allowUnsecureRequestsInAuthorizer) {
        this.allowUnsecureRequestsInAuthorizer = allowUnsecureRequestsInAuthorizer;
        return this;
    }

    public static enum AuthorizationPolicy {
        ALLOW,
        DENY,
        DEFAULT_ROLES;

    }
}

