/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.server;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConditionalModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.discovery.client.AnnouncementHttpServerInfo;
import com.facebook.airlift.event.client.EventBinder;
import com.facebook.airlift.http.server.AuthenticationFilter;
import com.facebook.airlift.http.server.Authenticator;
import com.facebook.airlift.http.server.HttpRequestEvent;
import com.facebook.airlift.http.server.HttpServer;
import com.facebook.airlift.http.server.HttpServerBinder;
import com.facebook.airlift.http.server.HttpServerConfig;
import com.facebook.airlift.http.server.HttpServerInfo;
import com.facebook.airlift.http.server.HttpServerProvider;
import com.facebook.airlift.http.server.HttpsConfig;
import com.facebook.airlift.http.server.LocalAnnouncementHttpServerInfo;
import com.facebook.airlift.http.server.RequestStats;
import com.facebook.airlift.http.server.TheAdminServlet;
import com.facebook.airlift.http.server.TheServlet;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import java.util.List;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.weakref.jmx.guice.ExportBinder;

public class HttpServerModule
extends AbstractConfigurationAwareModule {
    public static final String REALM_NAME = "Airlift";

    protected void setup(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(HttpServer.class).toProvider(HttpServerProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, HttpServer.ClientCertificate.class).setDefault().toInstance((Object)HttpServer.ClientCertificate.NONE);
        ExportBinder.newExporter((Binder)binder).export(HttpServer.class).withGeneratedName();
        binder.bind(HttpServerInfo.class).in(Scopes.SINGLETON);
        binder.bind(RequestStats.class).in(Scopes.SINGLETON);
        MapBinder.newMapBinder((Binder)binder, String.class, Servlet.class, TheServlet.class);
        Multibinder.newSetBinder((Binder)binder, Filter.class, TheServlet.class);
        Multibinder.newSetBinder((Binder)binder, Filter.class, TheAdminServlet.class);
        Multibinder.newSetBinder((Binder)binder, HttpServerBinder.HttpResourceBinding.class, TheServlet.class);
        OptionalBinder.newOptionalBinder((Binder)binder, SslContextFactory.Server.class);
        ExportBinder.newExporter((Binder)binder).export(RequestStats.class).withGeneratedName();
        ConfigBinder.configBinder((Binder)binder).bindConfig(HttpServerConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, HttpsConfig.class);
        EventBinder.eventBinder((Binder)binder).bindEventClient(new Class[]{HttpRequestEvent.class});
        binder.bind(AnnouncementHttpServerInfo.class).to(LocalAnnouncementHttpServerInfo.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, Filter.class, TheServlet.class).addBinding().to(AuthenticationFilter.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, Authenticator.class);
        this.install(ConditionalModule.installModuleIf(HttpServerConfig.class, HttpServerConfig::isHttpsEnabled, moduleBinder -> ConfigBinder.configBinder((Binder)moduleBinder).bindConfig(HttpsConfig.class)));
    }

    @Provides
    List<Authenticator> getAuthenticatorList(Set<Authenticator> authenticators) {
        return ImmutableList.copyOf(authenticators);
    }
}

