/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class RunLengthBlockEncoding
implements BlockEncoding {
    public static final String NAME = "RLE";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)block;
        sliceOutput.writeInt(rleBlock.getPositionCount());
        blockEncodingSerde.writeBlock(sliceOutput, rleBlock.getValue());
    }

    @Override
    public RunLengthEncodedBlock readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        Block value = blockEncodingSerde.readBlock(sliceInput);
        return new RunLengthEncodedBlock(value, positionCount);
    }
}

