/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Marker;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.kafka.KafkaConnectorConfig;
import com.facebook.presto.kafka.KafkaConnectorId;
import com.facebook.presto.kafka.KafkaHandleResolver;
import com.facebook.presto.kafka.KafkaInternalFieldDescription;
import com.facebook.presto.kafka.KafkaTableHandle;
import com.facebook.presto.kafka.KafkaTableLayoutHandle;
import com.facebook.presto.kafka.KafkaTopicDescription;
import com.facebook.presto.kafka.KafkaTopicFieldDescription;
import com.facebook.presto.kafka.KafkaTopicFieldGroup;
import com.facebook.presto.kafka.schema.TableDescriptionSupplier;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;

public class KafkaMetadata
implements ConnectorMetadata {
    private final String connectorId;
    private final boolean hideInternalColumns;
    private final TableDescriptionSupplier tableDescriptionSupplier;

    @Inject
    public KafkaMetadata(KafkaConnectorId connectorId, KafkaConnectorConfig kafkaConnectorConfig, TableDescriptionSupplier tableDescriptionSupplier) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        Objects.requireNonNull(kafkaConnectorConfig, "kafkaConfig is null");
        this.hideInternalColumns = kafkaConnectorConfig.isHideInternalColumns();
        this.tableDescriptionSupplier = Objects.requireNonNull(tableDescriptionSupplier, "tableDescriptionSupplier is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return (List)this.tableDescriptionSupplier.listTables().stream().map(SchemaTableName::getSchemaName).collect(ImmutableList.toImmutableList());
    }

    public KafkaTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        return this.getTopicDescription(schemaTableName).map(kafkaTopicDescription -> new KafkaTableHandle(this.connectorId, schemaTableName.getSchemaName(), schemaTableName.getTableName(), kafkaTopicDescription.getTopicName(), KafkaMetadata.getDataFormat(kafkaTopicDescription.getKey()), KafkaMetadata.getDataFormat(kafkaTopicDescription.getMessage()), kafkaTopicDescription.getKey().flatMap(KafkaTopicFieldGroup::getDataSchema), kafkaTopicDescription.getMessage().flatMap(KafkaTopicFieldGroup::getDataSchema), (List)this.getColumnHandles(schemaTableName).values().stream().map(KafkaColumnHandle.class::cast).collect(ImmutableList.toImmutableList()))).orElse(null);
    }

    private static String getDataFormat(Optional<KafkaTopicFieldGroup> fieldGroup) {
        return fieldGroup.map(KafkaTopicFieldGroup::getDataFormat).orElse("dummy");
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.getTableMetadata(KafkaHandleResolver.convertTableHandle(tableHandle).toSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return (List)this.tableDescriptionSupplier.listTables().stream().filter(tableName -> schemaName.map(tableName.getSchemaName()::equals).orElse(true)).collect(ImmutableList.toImmutableList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        KafkaTableHandle kafkaTableHandle = KafkaHandleResolver.convertTableHandle(tableHandle);
        return this.getColumnHandles(kafkaTableHandle.toSchemaTableName());
    }

    private Map<String, ColumnHandle> getColumnHandles(SchemaTableName schemaTableName) {
        KafkaTopicDescription kafkaTopicDescription = this.getRequiredTopicDescription(schemaTableName);
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        AtomicInteger index = new AtomicInteger(0);
        kafkaTopicDescription.getKey().ifPresent(key -> {
            List<KafkaTopicFieldDescription> fields = key.getFields();
            if (fields != null) {
                for (KafkaTopicFieldDescription kafkaTopicFieldDescription : fields) {
                    columnHandles.put((Object)kafkaTopicFieldDescription.getName(), (Object)kafkaTopicFieldDescription.getColumnHandle(this.connectorId, true, index.getAndIncrement()));
                }
            }
        });
        kafkaTopicDescription.getMessage().ifPresent(message -> {
            List<KafkaTopicFieldDescription> fields = message.getFields();
            if (fields != null) {
                for (KafkaTopicFieldDescription kafkaTopicFieldDescription : fields) {
                    columnHandles.put((Object)kafkaTopicFieldDescription.getName(), (Object)kafkaTopicFieldDescription.getColumnHandle(this.connectorId, false, index.getAndIncrement()));
                }
            }
        });
        for (KafkaInternalFieldDescription kafkaInternalFieldDescription : KafkaInternalFieldDescription.values()) {
            columnHandles.put((Object)kafkaInternalFieldDescription.getColumnName(), (Object)kafkaInternalFieldDescription.getColumnHandle(this.connectorId, index.getAndIncrement(), this.hideInternalColumns));
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        List tableNames = prefix.getTableName() == null ? this.listTables(session, prefix.getSchemaName()) : ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
        for (SchemaTableName tableName : tableNames) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(tableName).getColumns());
            }
            catch (TableNotFoundException e) {
                throw new IllegalStateException(String.format("Table %s cannot be gone because tables are statically defined", tableName), e);
            }
        }
        return columns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        KafkaHandleResolver.convertTableHandle(tableHandle);
        return KafkaHandleResolver.convertColumnHandle(columnHandle).getColumnMetadata();
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        KafkaTableHandle handle = KafkaHandleResolver.convertTableHandle(table);
        long startTimestamp = 0L;
        long endTimestamp = 0L;
        Optional domains = constraint.getSummary().getDomains();
        if (domains.isPresent()) {
            Map columnHandleDomainMap = (Map)domains.get();
            for (Map.Entry entry : columnHandleDomainMap.entrySet()) {
                if (!(entry.getKey() instanceof KafkaColumnHandle) || !((KafkaColumnHandle)entry.getKey()).getName().equals(KafkaInternalFieldDescription.OFFSET_TIMESTAMP_FIELD.getColumnName())) continue;
                Range span = ((Domain)entry.getValue()).getValues().getRanges().getSpan();
                Marker low = span.getLow();
                Marker high = span.getHigh();
                if (!low.isLowerUnbounded()) {
                    startTimestamp = (Long)low.getValue();
                }
                if (high.isUpperUnbounded()) continue;
                endTimestamp = (Long)high.getValue();
            }
        }
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new KafkaTableLayoutHandle(handle, startTimestamp, endTimestamp));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName schemaTableName) {
        KafkaTopicDescription table = this.getRequiredTopicDescription(schemaTableName);
        ImmutableList.Builder builder = ImmutableList.builder();
        table.getKey().ifPresent(key -> {
            List<KafkaTopicFieldDescription> fields = key.getFields();
            if (fields != null) {
                for (KafkaTopicFieldDescription fieldDescription : fields) {
                    builder.add((Object)fieldDescription.getColumnMetadata());
                }
            }
        });
        table.getMessage().ifPresent(message -> {
            List<KafkaTopicFieldDescription> fields = message.getFields();
            if (fields != null) {
                for (KafkaTopicFieldDescription fieldDescription : fields) {
                    builder.add((Object)fieldDescription.getColumnMetadata());
                }
            }
        });
        for (KafkaInternalFieldDescription fieldDescription : KafkaInternalFieldDescription.values()) {
            builder.add((Object)fieldDescription.getColumnMetadata(this.hideInternalColumns));
        }
        return new ConnectorTableMetadata(schemaTableName, (List)builder.build());
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        KafkaTableHandle table = (KafkaTableHandle)tableHandle;
        List actualColumns = (List)table.getColumns().stream().filter(col -> !col.isInternal()).collect(ImmutableList.toImmutableList());
        return new KafkaTableHandle(this.connectorId, table.getSchemaName(), table.getTableName(), table.getTopicName(), table.getKeyDataFormat(), table.getMessageDataFormat(), table.getKeyDataSchemaLocation(), table.getMessageDataSchemaLocation(), actualColumns);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    private KafkaTopicDescription getRequiredTopicDescription(SchemaTableName schemaTableName) {
        return this.getTopicDescription(schemaTableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
    }

    private Optional<KafkaTopicDescription> getTopicDescription(SchemaTableName schemaTableName) {
        return this.tableDescriptionSupplier.getTopicDescription(schemaTableName);
    }
}

