/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.common.Page;
import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.kafka.KafkaErrorCode;
import com.facebook.presto.kafka.PlainTextKafkaProducerFactory;
import com.facebook.presto.kafka.encoder.RowEncoder;
import com.facebook.presto.kafka.server.KafkaClusterMetadataSupplier;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class KafkaPageSink
implements ConnectorPageSink {
    private final String topicName;
    private final List<KafkaColumnHandle> columns;
    private final RowEncoder keyEncoder;
    private final RowEncoder messageEncoder;
    private final KafkaProducer<byte[], byte[]> producer;
    private final ErrorCountingCallback errorCounter;

    public KafkaPageSink(String schemaName, String topicName, List<KafkaColumnHandle> columns, RowEncoder keyEncoder, RowEncoder messageEncoder, PlainTextKafkaProducerFactory producerFactory, KafkaClusterMetadataSupplier supplier) {
        this.topicName = Objects.requireNonNull(topicName, "topicName is null");
        this.columns = (List)Objects.requireNonNull(ImmutableList.copyOf(columns), "columns is null");
        this.keyEncoder = Objects.requireNonNull(keyEncoder, "keyEncoder is null");
        this.messageEncoder = Objects.requireNonNull(messageEncoder, "messageEncoder is null");
        Objects.requireNonNull(producerFactory, "producerFactory is null");
        List<HostAddress> nodes = supplier.getNodes(schemaName);
        this.producer = producerFactory.create(nodes);
        this.errorCounter = new ErrorCountingCallback();
    }

    public CompletableFuture<?> appendPage(Page page) {
        for (int position = 0; position < page.getPositionCount(); ++position) {
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                if (this.columns.get(channel).isKeyCodec()) {
                    this.keyEncoder.appendColumnValue(page.getBlock(channel), position);
                    continue;
                }
                this.messageEncoder.appendColumnValue(page.getBlock(channel), position);
            }
            this.producer.send(new ProducerRecord(this.topicName, (Object)this.keyEncoder.toByteArray(), (Object)this.messageEncoder.toByteArray()), (Callback)this.errorCounter);
        }
        return NOT_BLOCKED;
    }

    public CompletableFuture<Collection<Slice>> finish() {
        this.producer.flush();
        this.producer.close();
        try {
            this.keyEncoder.close();
            this.messageEncoder.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close row encoders", e);
        }
        if (this.errorCounter.getErrorCount() > 0L) {
            throw new PrestoException((ErrorCodeSupplier)KafkaErrorCode.KAFKA_PRODUCER_ERROR, String.format("%d producer record('s) failed to send", this.errorCounter.getErrorCount()));
        }
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public void abort() {
        this.producer.close();
    }

    private static class ErrorCountingCallback
    implements Callback {
        private final AtomicLong errorCounter = new AtomicLong(0L);

        public void onCompletion(RecordMetadata recordMetadata, Exception e) {
            if (e != null) {
                this.errorCounter.incrementAndGet();
            }
        }

        public long getErrorCount() {
            return this.errorCounter.get();
        }
    }
}

