/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaConnectorConfig;
import com.facebook.presto.kafka.KafkaConnectorId;
import com.facebook.presto.kafka.KafkaConsumerManager;
import com.facebook.presto.kafka.KafkaErrorCode;
import com.facebook.presto.kafka.KafkaHandleResolver;
import com.facebook.presto.kafka.KafkaSplit;
import com.facebook.presto.kafka.KafkaTableHandle;
import com.facebook.presto.kafka.KafkaTableLayoutHandle;
import com.facebook.presto.kafka.server.KafkaClusterMetadataHelper;
import com.facebook.presto.kafka.server.KafkaClusterMetadataSupplier;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

public class KafkaSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final KafkaConsumerManager consumerManager;
    private final KafkaClusterMetadataSupplier clusterMetadataSupplier;

    @Inject
    public KafkaSplitManager(KafkaConnectorId connectorId, KafkaConnectorConfig kafkaConnectorConfig, KafkaClusterMetadataSupplier clusterMetadataSupplier, KafkaConsumerManager consumerManager) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.consumerManager = Objects.requireNonNull(consumerManager, "consumerManager is null");
        Objects.requireNonNull(kafkaConnectorConfig, "kafkaConfig is null");
        this.clusterMetadataSupplier = Objects.requireNonNull(clusterMetadataSupplier, "clusterMetadataSupplier is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        KafkaTableHandle kafkaTableHandle = KafkaHandleResolver.convertLayout(layout).getTable();
        try {
            String topic = kafkaTableHandle.getTopicName();
            KafkaTableLayoutHandle layoutHandle = (KafkaTableLayoutHandle)layout;
            HostAddress node = KafkaClusterMetadataHelper.selectRandom(this.clusterMetadataSupplier.getNodes(layoutHandle.getTable().getSchemaName()));
            KafkaConsumer<ByteBuffer, ByteBuffer> consumer = this.consumerManager.createConsumer(Thread.currentThread().getName(), node);
            List partitions = consumer.partitionsFor(topic);
            ImmutableList.Builder splits = ImmutableList.builder();
            for (PartitionInfo partition : partitions) {
                long endTimestamp;
                Node leader = partition.leader();
                if (leader == null) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Leader election in progress for Kafka topic '%s' partition %s", topic, partition.partition()));
                }
                HostAddress partitionLeader = HostAddress.fromParts((String)leader.host(), (int)leader.port());
                long startTimestamp = layoutHandle.getStartOffsetTimestamp();
                if (startTimestamp > (endTimestamp = layoutHandle.getEndOffsetTimestamp())) {
                    throw new IllegalArgumentException(String.format("Invalid Kafka Offset start/end pair: %s - %s", startTimestamp, endTimestamp));
                }
                TopicPartition topicPartition = new TopicPartition(partition.topic(), partition.partition());
                consumer.assign((Collection)ImmutableList.of((Object)topicPartition));
                long beginningOffset = startTimestamp == 0L ? (Long)consumer.beginningOffsets((Collection)ImmutableList.of((Object)topicPartition)).values().iterator().next() : KafkaSplitManager.findOffsetsByTimestamp(consumer, topicPartition, startTimestamp);
                long endOffset = endTimestamp == 0L ? (Long)consumer.endOffsets((Collection)ImmutableList.of((Object)topicPartition)).values().iterator().next() : KafkaSplitManager.findOffsetsByTimestamp(consumer, topicPartition, endTimestamp);
                KafkaSplit split = new KafkaSplit(this.connectorId, topic, kafkaTableHandle.getKeyDataFormat(), kafkaTableHandle.getMessageDataFormat(), kafkaTableHandle.getKeyDataSchemaLocation().map(KafkaSplitManager::readSchema), kafkaTableHandle.getMessageDataSchemaLocation().map(KafkaSplitManager::readSchema), partition.partition(), beginningOffset, endOffset, partitionLeader);
                splits.add((Object)split);
            }
            return new FixedSplitSource((Iterable)splits.build());
        }
        catch (Exception e) {
            if (e instanceof PrestoException) {
                throw e;
            }
            throw new PrestoException((ErrorCodeSupplier)KafkaErrorCode.KAFKA_SPLIT_ERROR, String.format("Cannot list splits for table '%s' reading topic '%s'", kafkaTableHandle.getTableName(), kafkaTableHandle.getTopicName()), (Throwable)e);
        }
    }

    private static long findOffsetsByTimestamp(KafkaConsumer<ByteBuffer, ByteBuffer> consumer, TopicPartition topicPartition, long timestamp) {
        try {
            Map topicPartitionOffsets = consumer.offsetsForTimes((Map)ImmutableMap.of((Object)topicPartition, (Object)timestamp));
            if (topicPartitionOffsets == null || topicPartitionOffsets.values().size() == 0) {
                return 0L;
            }
            OffsetAndTimestamp offsetAndTimestamp = (OffsetAndTimestamp)topicPartitionOffsets.values().iterator().next();
            return offsetAndTimestamp.offset();
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)KafkaErrorCode.KAFKA_CONSUMER_ERROR, String.format("Failed to find offset by timestamp: %d for partition %d", timestamp, topicPartition.partition()), (Throwable)e);
        }
    }

    private static String readSchema(String dataSchemaLocation) {
        InputStream inputStream = null;
        try {
            if (KafkaSplitManager.isURI(dataSchemaLocation.trim().toLowerCase(Locale.ENGLISH))) {
                try {
                    inputStream = new URL(dataSchemaLocation).openStream();
                }
                catch (MalformedURLException e) {
                    inputStream = new FileInputStream(dataSchemaLocation);
                }
            } else {
                inputStream = new FileInputStream(dataSchemaLocation);
            }
            String e = CharStreams.toString((Readable)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            try {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Could not parse the Avro schema at: " + dataSchemaLocation, (Throwable)e);
            }
            catch (Throwable throwable) {
                KafkaSplitManager.closeQuietly(inputStream);
                throw throwable;
            }
        }
        KafkaSplitManager.closeQuietly(inputStream);
        return e;
    }

    private static void closeQuietly(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isURI(String location) {
        try {
            URI.create(location);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

