/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.spi.HostAddress;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;

public class PlainTextKafkaProducerFactory {
    private final Map<String, Object> properties = ImmutableMap.builder().put((Object)"acks", (Object)"all").put((Object)"linger.ms", (Object)5).build();

    @Inject
    public PlainTextKafkaProducerFactory() {
    }

    public KafkaProducer<byte[], byte[]> create(List<HostAddress> bootstrapServers) {
        ImmutableMap propertiesWithBootstrapServers = ImmutableMap.builder().putAll(this.properties).put((Object)"bootstrap.servers", (Object)bootstrapServers.stream().map(HostAddress::toString).collect(Collectors.joining(","))).build();
        return new KafkaProducer((Map)propertiesWithBootstrapServers, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
    }
}

