/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka.encoder;

import com.facebook.presto.kafka.encoder.EncoderColumnHandle;
import com.facebook.presto.kafka.encoder.RowEncoder;
import com.facebook.presto.kafka.encoder.RowEncoderFactory;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class DispatchingRowEncoderFactory {
    private final Map<String, RowEncoderFactory> factories;

    @Inject
    public DispatchingRowEncoderFactory(Map<String, RowEncoderFactory> factories) {
        this.factories = ImmutableMap.copyOf(Objects.requireNonNull(factories, "factories is null"));
    }

    public RowEncoder create(ConnectorSession session, String dataFormat, Optional<String> dataSchema, List<EncoderColumnHandle> columnHandles) {
        Preconditions.checkArgument((boolean)this.factories.containsKey(dataFormat), (String)"unknown data format '%s'", (Object)dataFormat);
        return this.factories.get(dataFormat).create(session, dataSchema, columnHandles);
    }
}

