/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka.schema;

import com.facebook.presto.kafka.KafkaTopicDescription;
import com.facebook.presto.kafka.schema.TableDescriptionSupplier;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MapBasedTableDescriptionSupplier
implements TableDescriptionSupplier {
    private final Map<SchemaTableName, KafkaTopicDescription> map;

    public MapBasedTableDescriptionSupplier(Map<SchemaTableName, KafkaTopicDescription> map) {
        this.map = ImmutableMap.copyOf(Objects.requireNonNull(map, "map is null"));
    }

    @Override
    public Set<SchemaTableName> listTables() {
        return this.map.keySet();
    }

    @Override
    public Optional<KafkaTopicDescription> getTopicDescription(SchemaTableName schemaTableName) {
        return Optional.ofNullable(this.map.get(schemaTableName));
    }
}

