/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka.schema.file;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.kafka.KafkaConnectorConfig;
import com.facebook.presto.kafka.KafkaTopicDescription;
import com.facebook.presto.kafka.KafkaTopicFieldDescription;
import com.facebook.presto.kafka.KafkaTopicFieldGroup;
import com.facebook.presto.kafka.schema.MapBasedTableDescriptionSupplier;
import com.facebook.presto.kafka.schema.TableDescriptionSupplier;
import com.facebook.presto.kafka.schema.file.FileTableDescriptionSupplierConfig;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;

public class FileTableDescriptionSupplier
implements Provider<TableDescriptionSupplier> {
    public static final String NAME = "file";
    private static final Logger log = Logger.get(FileTableDescriptionSupplier.class);
    private final JsonCodec<KafkaTopicDescription> topicDescriptionCodec;
    private final File tableDescriptionDir;
    private final String defaultSchema;
    private final Set<String> tableNames;

    @Inject
    FileTableDescriptionSupplier(FileTableDescriptionSupplierConfig config, KafkaConnectorConfig kafkaConnectorConfig, JsonCodec<KafkaTopicDescription> topicDescriptionCodec) {
        this.topicDescriptionCodec = Objects.requireNonNull(topicDescriptionCodec, "topicDescriptionCodec is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(kafkaConnectorConfig, "kafkaConfig is null");
        this.tableDescriptionDir = config.getTableDescriptionDir();
        this.defaultSchema = kafkaConnectorConfig.getDefaultSchema();
        this.tableNames = ImmutableSet.copyOf(config.getTableNames());
    }

    public TableDescriptionSupplier get() {
        Map<SchemaTableName, KafkaTopicDescription> tables = this.populateTables();
        return new MapBasedTableDescriptionSupplier(tables);
    }

    private Map<SchemaTableName, KafkaTopicDescription> populateTables() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        log.debug("Loading kafka table definitions from %s", new Object[]{this.tableDescriptionDir.getAbsolutePath()});
        try {
            for (File file : FileTableDescriptionSupplier.listFiles(this.tableDescriptionDir)) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                KafkaTopicDescription table = (KafkaTopicDescription)this.topicDescriptionCodec.fromJson(Files.readAllBytes(file.toPath()));
                String schemaName = table.getSchemaName().orElse(this.defaultSchema);
                log.debug("Kafka table %s.%s: %s", new Object[]{schemaName, table.getTableName(), table});
                builder.put((Object)new SchemaTableName(schemaName, table.getTableName()), (Object)table);
            }
            ImmutableMap tableDefinitions = builder.build();
            log.debug("Loaded Table definitions: %s", new Object[]{tableDefinitions.keySet()});
            builder = ImmutableMap.builder();
            for (String definedTable : this.tableNames) {
                SchemaTableName tableName;
                try {
                    tableName = SchemaTableName.valueOf((String)definedTable);
                }
                catch (IllegalArgumentException iae) {
                    tableName = new SchemaTableName(this.defaultSchema, definedTable);
                }
                if (tableDefinitions.containsKey(tableName)) {
                    KafkaTopicDescription kafkaTable = (KafkaTopicDescription)tableDefinitions.get(tableName);
                    log.debug("Found Table definition for %s: %s", new Object[]{tableName, kafkaTable});
                    builder.put((Object)tableName, (Object)kafkaTable);
                    continue;
                }
                log.debug("Created dummy Table definition for %s", new Object[]{tableName});
                builder.put((Object)tableName, (Object)new KafkaTopicDescription(tableName.getTableName(), Optional.ofNullable(tableName.getSchemaName()), definedTable, Optional.of(new KafkaTopicFieldGroup("dummy", Optional.empty(), (List<KafkaTopicFieldDescription>)ImmutableList.of())), Optional.of(new KafkaTopicFieldGroup("dummy", Optional.empty(), (List<KafkaTopicFieldDescription>)ImmutableList.of()))));
            }
            return builder.build();
        }
        catch (IOException e) {
            log.warn((Throwable)e, "Error: ");
            throw new UncheckedIOException(e);
        }
    }

    private static List<File> listFiles(File dir) {
        Object[] files;
        if (dir != null && dir.isDirectory() && (files = dir.listFiles()) != null) {
            log.debug("Considering files: %s", new Object[]{Arrays.asList(files)});
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }
}

