/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile.text;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.rcfile.ColumnData;
import com.facebook.presto.rcfile.EncodeOutput;
import com.facebook.presto.rcfile.text.TextColumnEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;

public class BooleanEncoding
implements TextColumnEncoding {
    private static final Slice TRUE = Slices.utf8Slice((String)"TRUE");
    private static final Slice FALSE = Slices.utf8Slice((String)"FALSE");
    private final Type type;
    private final Slice nullSequence;

    public BooleanEncoding(Type type, Slice nullSequence) {
        this.type = type;
        this.nullSequence = nullSequence;
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                this.encodeValue(block, position, output);
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(int depth, Block block, int position, SliceOutput output) {
        this.encodeValue(block, position, output);
    }

    private void encodeValue(Block block, int position, SliceOutput output) {
        if (this.type.getBoolean(block, position)) {
            output.writeBytes(TRUE);
        } else {
            output.writeBytes(FALSE);
        }
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int length;
            int offset = columnData.getOffset(i);
            if (BooleanEncoding.isTrue(slice, offset, length = columnData.getLength(i))) {
                this.type.writeBoolean(builder, true);
                continue;
            }
            if (BooleanEncoding.isFalse(slice, offset, length)) {
                this.type.writeBoolean(builder, false);
                continue;
            }
            builder.appendNull();
        }
        return builder.build();
    }

    @Override
    public void decodeValueInto(int depth, BlockBuilder builder, Slice slice, int offset, int length) {
        this.type.writeBoolean(builder, BooleanEncoding.isTrue(slice, offset, length));
    }

    private static boolean isFalse(Slice slice, int start, int length) {
        return length == 5 && BooleanEncoding.toUpperCase(slice.getByte(start + 0)) == 70 && BooleanEncoding.toUpperCase(slice.getByte(start + 1)) == 65 && BooleanEncoding.toUpperCase(slice.getByte(start + 2)) == 76 && BooleanEncoding.toUpperCase(slice.getByte(start + 3)) == 83 && BooleanEncoding.toUpperCase(slice.getByte(start + 4)) == 69;
    }

    private static boolean isTrue(Slice slice, int start, int length) {
        return length == 4 && BooleanEncoding.toUpperCase(slice.getByte(start + 0)) == 84 && BooleanEncoding.toUpperCase(slice.getByte(start + 1)) == 82 && BooleanEncoding.toUpperCase(slice.getByte(start + 2)) == 85 && BooleanEncoding.toUpperCase(slice.getByte(start + 3)) == 69;
    }

    private static byte toUpperCase(byte b) {
        return BooleanEncoding.isLowerCase(b) ? (byte)(b - 32) : b;
    }

    private static boolean isLowerCase(byte b) {
        return b >= 97 && b <= 122;
    }
}

