/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.indexsegment.immutable;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.index.datasource.EmptyDataSource;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;
import org.apache.pinot.spi.data.readers.GenericRow;

public class EmptyIndexSegment
implements ImmutableSegment {
    private final SegmentMetadataImpl _segmentMetadata;

    public EmptyIndexSegment(SegmentMetadataImpl segmentMetadata) {
        this._segmentMetadata = segmentMetadata;
    }

    public String getSegmentName() {
        return this._segmentMetadata.getName();
    }

    public SegmentMetadataImpl getSegmentMetadata() {
        return this._segmentMetadata;
    }

    public DataSource getDataSource(String column) {
        ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
        Preconditions.checkNotNull((Object)columnMetadata, (Object)("ColumnMetadata for " + column + " should not be null. Potentially invalid column name specified."));
        return new EmptyDataSource(columnMetadata);
    }

    public Set<String> getColumnNames() {
        return this._segmentMetadata.getSchema().getColumnNames();
    }

    public Set<String> getPhysicalColumnNames() {
        return this._segmentMetadata.getSchema().getPhysicalColumnNames();
    }

    public void destroy() {
    }

    public List<StarTreeV2> getStarTrees() {
        return null;
    }

    @Nullable
    public ThreadSafeMutableRoaringBitmap getValidDocIds() {
        return null;
    }

    public GenericRow getRecord(int docId, GenericRow reuse) {
        throw new UnsupportedOperationException("Cannot read record from empty segment");
    }

    public Dictionary getDictionary(String column) {
        return null;
    }

    public ForwardIndexReader getForwardIndex(String column) {
        return null;
    }

    public InvertedIndexReader getInvertedIndex(String column) {
        return null;
    }

    public long getSegmentSizeBytes() {
        return 0L;
    }
}

