/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import org.apache.pinot.segment.spi.memory.CleanerUtil;

public class VarLengthValueWriter
implements Closeable {
    static final byte[] MAGIC_BYTES = ".vl;".getBytes(StandardCharsets.UTF_8);
    static final int VERSION = 1;
    static final int VERSION_OFFSET = MAGIC_BYTES.length;
    static final int NUM_VALUES_OFFSET = VERSION_OFFSET + 4;
    static final int DATA_SECTION_OFFSET_POSITION = NUM_VALUES_OFFSET + 4;
    static final int HEADER_LENGTH = DATA_SECTION_OFFSET_POSITION + 4;
    private final FileChannel _fileChannel;
    private final ByteBuffer _offsetBuffer;
    private final ByteBuffer _valueBuffer;

    public VarLengthValueWriter(File outputFile, int numValues) throws IOException {
        this._fileChannel = new RandomAccessFile(outputFile, "rw").getChannel();
        this._offsetBuffer = this._fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, Integer.MAX_VALUE);
        this._offsetBuffer.put(MAGIC_BYTES);
        this._offsetBuffer.putInt(1);
        this._offsetBuffer.putInt(numValues);
        this._offsetBuffer.putInt(HEADER_LENGTH);
        this._valueBuffer = this._offsetBuffer.duplicate();
        this._valueBuffer.position(HEADER_LENGTH + (numValues + 1) * 4);
    }

    public void add(byte[] value) throws IOException {
        this.add(value, value.length);
    }

    public void add(byte[] value, int length) throws IOException {
        this._offsetBuffer.putInt(this._valueBuffer.position());
        this._valueBuffer.put(value, 0, length);
    }

    @Override
    public void close() throws IOException {
        int fileLength = this._valueBuffer.position();
        this._offsetBuffer.putInt(fileLength);
        this._fileChannel.truncate(fileLength);
        this._fileChannel.close();
        if (CleanerUtil.UNMAP_SUPPORTED) {
            CleanerUtil.BufferCleaner cleaner = CleanerUtil.getCleaner();
            cleaner.freeBuffer(this._offsetBuffer);
        }
    }
}

