/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.writer.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.pinot.segment.local.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableOffHeapByteArrayStore
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MutableOffHeapByteArrayStore.class);
    private volatile List<Buffer> _buffers = new LinkedList<Buffer>();
    private int _numElements = 0;
    private volatile Buffer _currentBuffer;
    private final PinotDataBufferMemoryManager _memoryManager;
    private final String _allocationContext;
    private long _totalStringSize = 0L;
    private final int _startSize;

    @VisibleForTesting
    public int getStartSize() {
        return this._startSize;
    }

    public MutableOffHeapByteArrayStore(PinotDataBufferMemoryManager memoryManager, String allocationContext, int numArrays, int avgArrayLen) {
        this._memoryManager = memoryManager;
        this._allocationContext = allocationContext;
        this._startSize = numArrays * (avgArrayLen + 4);
        this.expand(this._startSize);
    }

    private Buffer expand(int size) {
        Buffer buffer = new Buffer(size, this._numElements, this._memoryManager, this._allocationContext);
        LinkedList<Buffer> newList = new LinkedList<Buffer>(this._buffers);
        newList.add(buffer);
        this._buffers = newList;
        this._currentBuffer = buffer;
        return buffer;
    }

    public byte[] get(int index) {
        List<Buffer> bufList = this._buffers;
        for (int x = bufList.size() - 1; x >= 0; --x) {
            Buffer buffer = bufList.get(x);
            if (index < buffer.getStartIndex()) continue;
            return buffer.get(index - buffer.getStartIndex());
        }
        throw new RuntimeException("dictionary ID '" + index + "' too low");
    }

    public int add(byte[] value) {
        int valueLength = value.length;
        Buffer buffer = this._currentBuffer;
        int index = buffer.add(value);
        if (index < 0) {
            int currentBufferSize = buffer.getSize();
            buffer = currentBufferSize << 1 >= 0 ? this.expand(Math.max(currentBufferSize << 1, valueLength + 4)) : this.expand(Integer.MAX_VALUE);
            index = buffer.add(value);
        }
        this._totalStringSize += (long)valueLength;
        ++this._numElements;
        return index + buffer.getStartIndex();
    }

    public boolean equalsValueAt(byte[] value, int index) {
        List<Buffer> bufList = this._buffers;
        for (int x = bufList.size() - 1; x >= 0; --x) {
            Buffer buffer = bufList.get(x);
            if (index < buffer.getStartIndex()) continue;
            return buffer.equalsValueAt(value, index - buffer.getStartIndex());
        }
        throw new RuntimeException("dictionary ID '" + index + "' too low");
    }

    @Override
    public void close() throws IOException {
        for (Buffer buffer : this._buffers) {
            buffer.close();
        }
    }

    public long getTotalOffHeapMemUsed() {
        long ret = 0L;
        for (Buffer buffer : this._buffers) {
            ret += (long)buffer.getSize();
        }
        return ret;
    }

    public long getAvgValueSize() {
        if (this._numElements > 0) {
            return this._totalStringSize / (long)this._numElements;
        }
        return 0L;
    }

    private static class Buffer
    implements Closeable {
        private final PinotDataBuffer _pinotDataBuffer;
        private final int _startIndex;
        private final int _size;
        private int _numValues = 0;
        private int _availEndOffset;

        private Buffer(int size, int startIndex, PinotDataBufferMemoryManager memoryManager, String allocationContext) {
            LOGGER.info("Allocating byte array store buffer of size {} for: {}", (Object)size, (Object)allocationContext);
            this._pinotDataBuffer = memoryManager.allocate(size, allocationContext);
            this._startIndex = startIndex;
            this._size = size;
            this._availEndOffset = size;
        }

        private int add(byte[] value) {
            int startOffset = this._availEndOffset - value.length;
            if (startOffset < (this._numValues + 1) * 4) {
                return -1;
            }
            this._pinotDataBuffer.readFrom((long)startOffset, value);
            this._pinotDataBuffer.putInt(this._numValues * 4, startOffset);
            this._availEndOffset = startOffset;
            return this._numValues++;
        }

        private boolean equalsValueAt(byte[] value, int index) {
            int startOffset;
            int endOffset = index != 0 ? this._pinotDataBuffer.getInt((index - 1) * 4) : this._size;
            if (endOffset - (startOffset = this._pinotDataBuffer.getInt(index * 4)) != value.length) {
                return false;
            }
            int i = 0;
            int j = startOffset;
            while (i < value.length) {
                if (value[i] != this._pinotDataBuffer.getByte(j)) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }

        private byte[] get(int index) {
            int startOffset = this._pinotDataBuffer.getInt(index * 4);
            int endOffset = index != 0 ? this._pinotDataBuffer.getInt((index - 1) * 4) : this._size;
            byte[] value = new byte[endOffset - startOffset];
            this._pinotDataBuffer.copyTo((long)startOffset, value);
            return value;
        }

        private int getSize() {
            return this._size;
        }

        private int getStartIndex() {
            return this._startIndex;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

