/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.dictionary;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pinot.segment.spi.index.reader.MutableDictionary;

public abstract class BaseOnHeapMutableDictionary
implements MutableDictionary {
    private static final int SHIFT_OFFSET = 13;
    private static final int INITIAL_DICTIONARY_SIZE = 8192;
    private static final int MASK = 8191;
    private final Map<Object, Integer> _valueToDictId = new ConcurrentHashMap<Object, Integer>(8192);
    private final Object[][] _dictIdToValue = new Object[8192][];
    private volatile int _entriesIndexed = 0;

    public Object get(int dictId) {
        return this._dictIdToValue[dictId >>> 13][dictId & 0x1FFF];
    }

    public int length() {
        return this._entriesIndexed;
    }

    public void close() throws IOException {
    }

    protected int indexValue(Object value) {
        Integer dictId = this._valueToDictId.get(value);
        if (dictId != null) {
            return dictId;
        }
        int newValueDictId = this._entriesIndexed;
        int arrayIndex = newValueDictId >>> 13;
        int arrayOffset = newValueDictId & 0x1FFF;
        if (arrayOffset == 0) {
            this._dictIdToValue[arrayIndex] = new Object[8192];
        }
        this._dictIdToValue[arrayIndex][arrayOffset] = value;
        this._valueToDictId.put(value, newValueDictId);
        this._entriesIndexed = newValueDictId + 1;
        return newValueDictId;
    }

    protected int getDictId(Object value) {
        Integer dictId = this._valueToDictId.get(value);
        if (dictId == null) {
            return -1;
        }
        return dictId;
    }
}

