/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.segment.local.function.FunctionEvaluator;
import org.apache.pinot.segment.local.function.FunctionEvaluatorFactory;
import org.apache.pinot.segment.local.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.TransformConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;

public class ExpressionTransformer
implements RecordTransformer {
    private final LinkedHashMap<String, FunctionEvaluator> _expressionEvaluators = new LinkedHashMap();

    public ExpressionTransformer(TableConfig tableConfig, Schema schema) {
        HashMap<String, FunctionEvaluator> expressionEvaluators = new HashMap<String, FunctionEvaluator>();
        if (tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getTransformConfigs() != null) {
            for (TransformConfig transformConfig : tableConfig.getIngestionConfig().getTransformConfigs()) {
                expressionEvaluators.put(transformConfig.getColumnName(), FunctionEvaluatorFactory.getExpressionEvaluator(transformConfig.getTransformFunction()));
            }
        }
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            FunctionEvaluator functionEvaluator;
            String fieldName = fieldSpec.getName();
            if (fieldSpec.isVirtualColumn() || expressionEvaluators.containsKey(fieldName) || (functionEvaluator = FunctionEvaluatorFactory.getExpressionEvaluator(fieldSpec)) == null) continue;
            expressionEvaluators.put(fieldName, functionEvaluator);
        }
        HashSet<String> visited = new HashSet<String>();
        for (Map.Entry entry : expressionEvaluators.entrySet()) {
            this.topologicalSort((String)entry.getKey(), expressionEvaluators, visited);
        }
    }

    private void topologicalSort(String column, Map<String, FunctionEvaluator> expressionEvaluators, Set<String> visited) {
        if (visited.contains(column)) {
            return;
        }
        FunctionEvaluator functionEvaluator = expressionEvaluators.get(column);
        if (functionEvaluator == null) {
            visited.add(column);
            return;
        }
        List<String> arguments = functionEvaluator.getArguments();
        for (String arg : arguments) {
            this.topologicalSort(arg, expressionEvaluators, visited);
        }
        visited.add(column);
        this._expressionEvaluators.put(column, functionEvaluator);
    }

    @Override
    public GenericRow transform(GenericRow record) {
        for (Map.Entry<String, FunctionEvaluator> entry : this._expressionEvaluators.entrySet()) {
            String column = entry.getKey();
            FunctionEvaluator transformFunctionEvaluator = entry.getValue();
            if (record.getValue(column) != null) continue;
            Object result = transformFunctionEvaluator.evaluate(record);
            record.putValue(column, result);
        }
        return record;
    }
}

