/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.segment.local.indexsegment.mutable.IntermediateSegment;
import org.apache.pinot.segment.local.realtime.converter.stats.MutableColumnStatistics;
import org.apache.pinot.segment.spi.creator.ColumnStatistics;
import org.apache.pinot.segment.spi.creator.SegmentPreIndexStatsContainer;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class IntermediateSegmentStatsContainer
implements SegmentPreIndexStatsContainer {
    private final IntermediateSegment _intermediateSegment;
    private final Map<String, ColumnStatistics> _columnStatisticsMap = new HashMap<String, ColumnStatistics>();

    public IntermediateSegmentStatsContainer(IntermediateSegment intermediateSegment) {
        this._intermediateSegment = intermediateSegment;
        for (String columnName : intermediateSegment.getPhysicalColumnNames()) {
            DataSource dataSource = intermediateSegment.getDataSource(columnName);
            this._columnStatisticsMap.put(columnName, new MutableColumnStatistics(dataSource, null));
        }
    }

    public ColumnStatistics getColumnProfileFor(String column) {
        return this._columnStatisticsMap.get(column);
    }

    public int getTotalDocCount() {
        return this._intermediateSegment.getNumDocsIndexed();
    }
}

