/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.fwd;

import java.io.File;
import java.io.IOException;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkSVForwardIndexWriter;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

public class MultiValueVarByteRawIndexCreator
implements ForwardIndexCreator {
    private static final int TARGET_MAX_CHUNK_SIZE = 0x100000;
    private final VarByteChunkSVForwardIndexWriter _indexWriter;
    private final FieldSpec.DataType _valueType;

    public MultiValueVarByteRawIndexCreator(File baseIndexDir, ChunkCompressionType compressionType, String column, int totalDocs, FieldSpec.DataType valueType, int maxRowLengthInBytes, int maxNumberOfElements) throws IOException {
        this(baseIndexDir, compressionType, column, totalDocs, valueType, 2, maxRowLengthInBytes, maxNumberOfElements);
    }

    public MultiValueVarByteRawIndexCreator(File baseIndexDir, ChunkCompressionType compressionType, String column, int totalDocs, FieldSpec.DataType valueType, int writerVersion, int maxRowLengthInBytes, int maxNumberOfElements) throws IOException {
        int maxLengthPrefixes = 4 * maxNumberOfElements;
        int totalMaxLength = 4 + maxRowLengthInBytes + maxLengthPrefixes;
        File file = new File(baseIndexDir, column + ".mv.raw.fwd");
        int numDocsPerChunk = Math.max(0x100000 / (totalMaxLength + 4), 1);
        this._indexWriter = new VarByteChunkSVForwardIndexWriter(file, compressionType, totalDocs, numDocsPerChunk, totalMaxLength, writerVersion);
        this._valueType = valueType;
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return false;
    }

    public FieldSpec.DataType getValueType() {
        return this._valueType;
    }

    public void putStringMV(String[] values) {
        this._indexWriter.putStrings(values);
    }

    public void putBytesMV(byte[][] values) {
        this._indexWriter.putByteArrays(values);
    }

    public void close() throws IOException {
        this._indexWriter.close();
    }
}

