/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.stats;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.creator.ColumnStatistics;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.segment.spi.partition.PartitionFunctionFactory;
import org.apache.pinot.spi.data.FieldSpec;

public abstract class AbstractColumnStatisticsCollector
implements ColumnStatistics {
    protected static final int INITIAL_HASH_SET_SIZE = 1000;
    private Object _previousValue = null;
    protected final FieldSpec _fieldSpec;
    protected boolean _isSorted = true;
    private final String _column;
    protected int _totalNumberOfEntries = 0;
    protected int _maxNumberOfMultiValues = 0;
    protected int _maxLengthOfMultiValues = 0;
    private PartitionFunction _partitionFunction;
    private final int _numPartitions;
    private final Map<String, String> _functionConfig;
    private final Set<Integer> _partitions;

    public AbstractColumnStatisticsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        this._column = column;
        this._fieldSpec = statsCollectorConfig.getFieldSpecForColumn(column);
        String partitionFunctionName = statsCollectorConfig.getPartitionFunctionName(column);
        int numPartitions = statsCollectorConfig.getNumPartitions(column);
        this._functionConfig = statsCollectorConfig.getPartitionFunctionConfig(column);
        this._partitionFunction = partitionFunctionName != null ? PartitionFunctionFactory.getPartitionFunction((String)partitionFunctionName, (int)numPartitions, this._functionConfig) : null;
        this._numPartitions = statsCollectorConfig.getNumPartitions(column);
        this._partitions = this._partitionFunction != null ? new HashSet<Integer>() : null;
    }

    public int getMaxNumberOfMultiValues() {
        return this._maxNumberOfMultiValues;
    }

    public int getMaxLengthOfMultiValues() {
        return this._maxLengthOfMultiValues;
    }

    void addressSorted(Object entry) {
        if (this._isSorted) {
            Comparable prevValue;
            Comparable origin;
            if (this._previousValue != null && !entry.equals(this._previousValue) && this._previousValue != null && (origin = (Comparable)entry).compareTo(prevValue = (Comparable)this._previousValue) < 0) {
                this._isSorted = false;
            }
            this._previousValue = entry;
        }
    }

    public boolean isSorted() {
        return this._fieldSpec.isSingleValueField() && this._isSorted;
    }

    public abstract void collect(Object var1);

    public abstract Object getMinValue();

    public abstract Object getMaxValue();

    public abstract Object getUniqueValuesSet();

    public abstract int getCardinality();

    public int getLengthOfShortestElement() {
        return -1;
    }

    public int getLengthOfLargestElement() {
        return -1;
    }

    public abstract void seal();

    public PartitionFunction getPartitionFunction() {
        return this._partitionFunction;
    }

    public int getNumPartitions() {
        return this._numPartitions;
    }

    @Nullable
    public Map<String, String> getPartitionFunctionConfig() {
        return this._functionConfig;
    }

    @Nullable
    public Set<Integer> getPartitions() {
        return this._partitions;
    }

    protected void updatePartition(Object value) {
        if (this._partitionFunction != null) {
            this._partitions.add(this._partitionFunction.getPartition(value));
        }
    }

    void updateTotalNumberOfEntries(Object[] entries) {
        this._totalNumberOfEntries += entries.length;
    }

    public int getTotalNumberOfEntries() {
        return this._totalNumberOfEntries;
    }
}

