/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public class FloatDictionary
extends BaseImmutableDictionary {
    public FloatDictionary(PinotDataBuffer dataBuffer, int length) {
        super(dataBuffer, length, 4, (byte)0);
    }

    public int insertionIndexOf(String stringValue) {
        return this.binarySearch(Float.parseFloat(stringValue));
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.FLOAT;
    }

    public Float get(int dictId) {
        return Float.valueOf(this.getFloat(dictId));
    }

    public int getIntValue(int dictId) {
        return (int)this.getFloat(dictId);
    }

    public long getLongValue(int dictId) {
        return (long)this.getFloat(dictId);
    }

    public float getFloatValue(int dictId) {
        return this.getFloat(dictId);
    }

    public double getDoubleValue(int dictId) {
        return this.getFloat(dictId);
    }

    public String getStringValue(int dictId) {
        return Float.toString(this.getFloat(dictId));
    }
}

