/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.forward;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.apache.pinot.segment.local.io.compression.ChunkCompressorFactory;
import org.apache.pinot.segment.local.io.writer.impl.BaseChunkSVForwardIndexWriter;
import org.apache.pinot.segment.local.segment.index.readers.forward.ChunkReaderContext;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.compression.ChunkDecompressor;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseChunkSVForwardIndexReader
implements ForwardIndexReader<ChunkReaderContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseChunkSVForwardIndexReader.class);
    protected final PinotDataBuffer _dataBuffer;
    protected final FieldSpec.DataType _valueType;
    protected final int _numChunks;
    protected final int _numDocsPerChunk;
    protected final int _lengthOfLongestEntry;
    protected final boolean _isCompressed;
    protected final ChunkDecompressor _chunkDecompressor;
    protected final PinotDataBuffer _dataHeader;
    protected final int _headerEntryChunkOffsetSize;
    protected final PinotDataBuffer _rawData;

    public BaseChunkSVForwardIndexReader(PinotDataBuffer dataBuffer, FieldSpec.DataType valueType) {
        this._dataBuffer = dataBuffer;
        this._valueType = valueType;
        int headerOffset = 0;
        int version = this._dataBuffer.getInt(headerOffset);
        this._numChunks = this._dataBuffer.getInt(headerOffset += 4);
        this._numDocsPerChunk = this._dataBuffer.getInt(headerOffset += 4);
        this._lengthOfLongestEntry = this._dataBuffer.getInt(headerOffset += 4);
        if (valueType.isFixedWidth()) {
            Preconditions.checkState((this._lengthOfLongestEntry == valueType.size() ? 1 : 0) != 0);
        }
        int dataHeaderStart = headerOffset += 4;
        if (version > 1) {
            this._dataBuffer.getInt(headerOffset);
            ChunkCompressionType compressionType = ChunkCompressionType.valueOf((int)this._dataBuffer.getInt(headerOffset += 4));
            this._chunkDecompressor = ChunkCompressorFactory.getDecompressor(compressionType);
            this._isCompressed = !compressionType.equals((Object)ChunkCompressionType.PASS_THROUGH);
            dataHeaderStart = this._dataBuffer.getInt(headerOffset += 4);
        } else {
            this._isCompressed = true;
            this._chunkDecompressor = ChunkCompressorFactory.getDecompressor(ChunkCompressionType.SNAPPY);
        }
        this._headerEntryChunkOffsetSize = BaseChunkSVForwardIndexWriter.getHeaderEntryChunkOffsetSize(version);
        int dataHeaderLength = this._numChunks * this._headerEntryChunkOffsetSize;
        int rawDataStart = dataHeaderStart + dataHeaderLength;
        this._dataHeader = this._dataBuffer.view((long)dataHeaderStart, (long)rawDataStart);
        this._rawData = this._dataBuffer.view((long)rawDataStart, this._dataBuffer.size());
    }

    protected ByteBuffer getChunkBuffer(int docId, ChunkReaderContext context) {
        int chunkId = docId / this._numDocsPerChunk;
        if (context.getChunkId() == chunkId) {
            return context.getChunkBuffer();
        }
        return this.decompressChunk(chunkId, context);
    }

    protected ByteBuffer decompressChunk(int chunkId, ChunkReaderContext context) {
        int chunkSize;
        long chunkPosition = this.getChunkPosition(chunkId);
        if (chunkId == this._numChunks - 1) {
            chunkSize = (int)(this._dataBuffer.size() - chunkPosition);
        } else {
            long nextChunkOffset = this.getChunkPosition(chunkId + 1);
            chunkSize = (int)(nextChunkOffset - chunkPosition);
        }
        ByteBuffer decompressedBuffer = context.getChunkBuffer();
        decompressedBuffer.clear();
        try {
            this._chunkDecompressor.decompress(this._dataBuffer.toDirectByteBuffer(chunkPosition, chunkSize), decompressedBuffer);
        }
        catch (IOException e) {
            LOGGER.error("Exception caught while decompressing data chunk", (Throwable)e);
            throw new RuntimeException(e);
        }
        context.setChunkId(chunkId);
        return decompressedBuffer;
    }

    protected long getChunkPosition(int chunkId) {
        if (this._headerEntryChunkOffsetSize == 4) {
            return this._dataHeader.getInt(chunkId * this._headerEntryChunkOffsetSize);
        }
        return this._dataHeader.getLong(chunkId * this._headerEntryChunkOffsetSize);
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getValueType() {
        return this._valueType;
    }

    public void readValuesSV(int[] docIds, int length, int[] values, ChunkReaderContext context) {
        block10: {
            block9: {
                if (!this.getValueType().isFixedWidth() || this._isCompressed || !this.isContiguousRange(docIds, length)) break block9;
                switch (this.getValueType()) {
                    case INT: {
                        int minOffset = docIds[0] * 4;
                        IntBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 4).asIntBuffer();
                        buffer.get(values, 0, length);
                        break block10;
                    }
                    case LONG: {
                        int minOffset = docIds[0] * 8;
                        LongBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 8).asLongBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = (int)buffer.get(i);
                        }
                        break block10;
                    }
                    case FLOAT: {
                        int minOffset = docIds[0] * 4;
                        FloatBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 4).asFloatBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = (int)buffer.get(i);
                        }
                        break block10;
                    }
                    case DOUBLE: {
                        int minOffset = docIds[0] * 8;
                        DoubleBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 8).asDoubleBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = (int)buffer.get(i);
                        }
                        break block10;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            super.readValuesSV(docIds, length, values, (ForwardIndexReaderContext)context);
        }
    }

    public void readValuesSV(int[] docIds, int length, long[] values, ChunkReaderContext context) {
        block10: {
            block9: {
                if (!this.getValueType().isFixedWidth() || this._isCompressed || !this.isContiguousRange(docIds, length)) break block9;
                switch (this.getValueType()) {
                    case INT: {
                        int minOffset = docIds[0] * 4;
                        IntBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 4).asIntBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = buffer.get(i);
                        }
                        break block10;
                    }
                    case LONG: {
                        int minOffset = docIds[0] * 8;
                        LongBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 8).asLongBuffer();
                        buffer.get(values, 0, length);
                        break block10;
                    }
                    case FLOAT: {
                        int minOffset = docIds[0] * 4;
                        FloatBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 4).asFloatBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = (long)buffer.get(i);
                        }
                        break block10;
                    }
                    case DOUBLE: {
                        int minOffset = docIds[0] * 8;
                        DoubleBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 8).asDoubleBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = (long)buffer.get(i);
                        }
                        break block10;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            super.readValuesSV(docIds, length, values, (ForwardIndexReaderContext)context);
        }
    }

    public void readValuesSV(int[] docIds, int length, float[] values, ChunkReaderContext context) {
        block10: {
            block9: {
                if (!this.getValueType().isFixedWidth() || this._isCompressed || !this.isContiguousRange(docIds, length)) break block9;
                switch (this.getValueType()) {
                    case INT: {
                        int minOffset = docIds[0] * 4;
                        IntBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 4).asIntBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = buffer.get(i);
                        }
                        break block10;
                    }
                    case LONG: {
                        int minOffset = docIds[0] * 8;
                        LongBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 8).asLongBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = buffer.get(i);
                        }
                        break block10;
                    }
                    case FLOAT: {
                        int minOffset = docIds[0] * 4;
                        FloatBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 4).asFloatBuffer();
                        buffer.get(values, 0, length);
                        break block10;
                    }
                    case DOUBLE: {
                        int minOffset = docIds[0] * 8;
                        DoubleBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 8).asDoubleBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = (float)buffer.get(i);
                        }
                        break block10;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            super.readValuesSV(docIds, length, values, (ForwardIndexReaderContext)context);
        }
    }

    public void readValuesSV(int[] docIds, int length, double[] values, ChunkReaderContext context) {
        block10: {
            block9: {
                if (!this.getValueType().isFixedWidth() || this._isCompressed || !this.isContiguousRange(docIds, length)) break block9;
                switch (this.getValueType()) {
                    case INT: {
                        int minOffset = docIds[0] * 4;
                        IntBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 4).asIntBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = buffer.get(i);
                        }
                        break block10;
                    }
                    case LONG: {
                        int minOffset = docIds[0] * 8;
                        this.getLong(0, context);
                        LongBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 8).asLongBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = buffer.get(i);
                        }
                        break block10;
                    }
                    case FLOAT: {
                        int minOffset = docIds[0] * 4;
                        FloatBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 4).asFloatBuffer();
                        for (int i = 0; i < buffer.limit(); ++i) {
                            values[i] = buffer.get(i);
                        }
                        break block10;
                    }
                    case DOUBLE: {
                        int minOffset = docIds[0] * 8;
                        DoubleBuffer buffer = this._rawData.toDirectByteBuffer((long)minOffset, length * 8).asDoubleBuffer();
                        buffer.get(values, 0, length);
                        break block10;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            super.readValuesSV(docIds, length, values, (ForwardIndexReaderContext)context);
        }
    }

    public void close() {
    }

    private boolean isContiguousRange(int[] docIds, int length) {
        return docIds[length - 1] - docIds[0] == length - 1;
    }
}

