/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.forward;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.index.readers.forward.BaseChunkSVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.ChunkReaderContext;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public final class VarByteChunkMVForwardIndexReader
extends BaseChunkSVForwardIndexReader {
    private static final int ROW_OFFSET_SIZE = 4;
    private final int _maxChunkSize;

    public VarByteChunkMVForwardIndexReader(PinotDataBuffer dataBuffer, FieldSpec.DataType valueType) {
        super(dataBuffer, valueType);
        this._maxChunkSize = this._numDocsPerChunk * (4 + this._lengthOfLongestEntry);
    }

    @Nullable
    public ChunkReaderContext createContext() {
        if (this._isCompressed) {
            return new ChunkReaderContext(this._maxChunkSize);
        }
        return null;
    }

    public int getStringMV(int docId, String[] valueBuffer, ChunkReaderContext context) {
        byte[] compressedBytes = this._isCompressed ? this.getBytesCompressed(docId, context) : this.getBytesUncompressed(docId);
        ByteBuffer byteBuffer = ByteBuffer.wrap(compressedBytes);
        int numValues = byteBuffer.getInt();
        int contentOffset = (numValues + 1) * 4;
        for (int i = 0; i < numValues; ++i) {
            int length = byteBuffer.getInt((i + 1) * 4);
            byte[] bytes = new byte[length];
            byteBuffer.position(contentOffset);
            byteBuffer.get(bytes, 0, length);
            valueBuffer[i] = new String(bytes, StandardCharsets.UTF_8);
            contentOffset += length;
        }
        return numValues;
    }

    public int getBytesMV(int docId, byte[][] valueBuffer, ChunkReaderContext context) {
        byte[] compressedBytes = this._isCompressed ? this.getBytesCompressed(docId, context) : this.getBytesUncompressed(docId);
        ByteBuffer byteBuffer = ByteBuffer.wrap(compressedBytes);
        int numValues = byteBuffer.getInt();
        int contentOffset = (numValues + 1) * 4;
        for (int i = 0; i < numValues; ++i) {
            int length = byteBuffer.getInt((i + 1) * 4);
            byte[] bytes = new byte[length];
            byteBuffer.position(contentOffset);
            byteBuffer.get(bytes, 0, length);
            valueBuffer[i] = bytes;
            contentOffset += length;
        }
        return numValues;
    }

    public byte[] getBytes(int docId, ChunkReaderContext context) {
        if (this._isCompressed) {
            return this.getBytesCompressed(docId, context);
        }
        return this.getBytesUncompressed(docId);
    }

    private byte[] getBytesCompressed(int docId, ChunkReaderContext context) {
        int chunkRowId = docId % this._numDocsPerChunk;
        ByteBuffer chunkBuffer = this.getChunkBuffer(docId, context);
        int valueStartOffset = chunkBuffer.getInt(chunkRowId * 4);
        int valueEndOffset = this.getValueEndOffset(chunkRowId, chunkBuffer);
        byte[] bytes = new byte[valueEndOffset - valueStartOffset];
        chunkBuffer.position(valueStartOffset);
        chunkBuffer.get(bytes);
        return bytes;
    }

    private byte[] getBytesUncompressed(int docId) {
        int chunkId = docId / this._numDocsPerChunk;
        int chunkRowId = docId % this._numDocsPerChunk;
        long chunkStartOffset = this.getChunkPosition(chunkId);
        long valueStartOffset = chunkStartOffset + (long)this._dataBuffer.getInt(chunkStartOffset + (long)chunkRowId * 4L);
        long valueEndOffset = this.getValueEndOffset(chunkId, chunkRowId, chunkStartOffset);
        byte[] bytes = new byte[(int)(valueEndOffset - valueStartOffset)];
        this._dataBuffer.copyTo(valueStartOffset, bytes);
        return bytes;
    }

    private int getValueEndOffset(int rowId, ByteBuffer chunkBuffer) {
        if (rowId == this._numDocsPerChunk - 1) {
            return chunkBuffer.limit();
        }
        int valueEndOffset = chunkBuffer.getInt((rowId + 1) * 4);
        if (valueEndOffset == 0) {
            return chunkBuffer.limit();
        }
        return valueEndOffset;
    }

    private long getValueEndOffset(int chunkId, int chunkRowId, long chunkStartOffset) {
        if (chunkId == this._numChunks - 1) {
            if (chunkRowId == this._numDocsPerChunk - 1) {
                return this._dataBuffer.size();
            }
            int valueEndOffsetInChunk = this._dataBuffer.getInt(chunkStartOffset + (long)(chunkRowId + 1) * 4L);
            if (valueEndOffsetInChunk == 0) {
                return this._dataBuffer.size();
            }
            return chunkStartOffset + (long)valueEndOffsetInChunk;
        }
        if (chunkRowId == this._numDocsPerChunk - 1) {
            return this.getChunkPosition(chunkId + 1);
        }
        return chunkStartOffset + (long)this._dataBuffer.getInt(chunkStartOffset + (long)(chunkRowId + 1) * 4L);
    }
}

