/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.segment.local.upsert.PartialUpsertHandler;
import org.apache.pinot.segment.local.upsert.RecordLocation;
import org.apache.pinot.segment.local.utils.HashUtils;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.index.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.apache.pinot.spi.utils.ByteArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PartitionUpsertMetadataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionUpsertMetadataManager.class);
    private final String _tableNameWithType;
    private final int _partitionId;
    private final ServerMetrics _serverMetrics;
    private final PartialUpsertHandler _partialUpsertHandler;
    private final UpsertConfig.HashFunction _hashFunction;
    @VisibleForTesting
    final ConcurrentHashMap<Object, RecordLocation> _primaryKeyToRecordLocationMap = new ConcurrentHashMap();
    private final GenericRow _reuse = new GenericRow();

    public PartitionUpsertMetadataManager(String tableNameWithType, int partitionId, ServerMetrics serverMetrics, @Nullable PartialUpsertHandler partialUpsertHandler, UpsertConfig.HashFunction hashFunction) {
        this._tableNameWithType = tableNameWithType;
        this._partitionId = partitionId;
        this._serverMetrics = serverMetrics;
        this._partialUpsertHandler = partialUpsertHandler;
        this._hashFunction = hashFunction;
    }

    public void addSegment(IndexSegment segment, Iterator<RecordInfo> recordInfoIterator) {
        String segmentName = segment.getSegmentName();
        LOGGER.info("Adding upsert metadata for segment: {}", (Object)segmentName);
        ThreadSafeMutableRoaringBitmap validDocIds = Objects.requireNonNull(segment.getValidDocIds());
        while (recordInfoIterator.hasNext()) {
            RecordInfo recordInfo = recordInfoIterator.next();
            this._primaryKeyToRecordLocationMap.compute(PartitionUpsertMetadataManager.hashPrimaryKey(recordInfo._primaryKey, this._hashFunction), (primaryKey, currentRecordLocation) -> {
                if (currentRecordLocation != null) {
                    IndexSegment currentSegment = currentRecordLocation.getSegment();
                    if (segment == currentSegment) {
                        if (recordInfo._comparisonValue.compareTo(currentRecordLocation.getComparisonValue()) >= 0) {
                            validDocIds.replace(currentRecordLocation.getDocId(), recordInfo._docId);
                            return new RecordLocation(segment, recordInfo._docId, recordInfo._comparisonValue);
                        }
                        return currentRecordLocation;
                    }
                    String currentSegmentName = currentSegment.getSegmentName();
                    if (segmentName.equals(currentSegmentName)) {
                        if (recordInfo._comparisonValue.compareTo(currentRecordLocation.getComparisonValue()) >= 0) {
                            validDocIds.add(recordInfo._docId);
                            return new RecordLocation(segment, recordInfo._docId, recordInfo._comparisonValue);
                        }
                        return currentRecordLocation;
                    }
                    if (recordInfo._comparisonValue.compareTo(currentRecordLocation.getComparisonValue()) > 0 || recordInfo._comparisonValue == currentRecordLocation.getComparisonValue() && LLCSegmentName.isLowLevelConsumerSegmentName((String)segmentName) && LLCSegmentName.isLowLevelConsumerSegmentName((String)currentSegmentName) && LLCSegmentName.getSequenceNumber((String)segmentName) > LLCSegmentName.getSequenceNumber((String)currentSegmentName)) {
                        Objects.requireNonNull(currentSegment.getValidDocIds()).remove(currentRecordLocation.getDocId());
                        validDocIds.add(recordInfo._docId);
                        return new RecordLocation(segment, recordInfo._docId, recordInfo._comparisonValue);
                    }
                    return currentRecordLocation;
                }
                validDocIds.add(recordInfo._docId);
                return new RecordLocation(segment, recordInfo._docId, recordInfo._comparisonValue);
            });
        }
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.UPSERT_PRIMARY_KEYS_COUNT, (long)this._primaryKeyToRecordLocationMap.size());
    }

    public void addRecord(IndexSegment segment, RecordInfo recordInfo) {
        ThreadSafeMutableRoaringBitmap validDocIds = Objects.requireNonNull(segment.getValidDocIds());
        this._primaryKeyToRecordLocationMap.compute(PartitionUpsertMetadataManager.hashPrimaryKey(recordInfo._primaryKey, this._hashFunction), (primaryKey, currentRecordLocation) -> {
            if (currentRecordLocation != null) {
                if (recordInfo._comparisonValue.compareTo(currentRecordLocation.getComparisonValue()) >= 0) {
                    IndexSegment currentSegment = currentRecordLocation.getSegment();
                    int currentDocId = currentRecordLocation.getDocId();
                    if (segment == currentSegment) {
                        validDocIds.replace(currentDocId, recordInfo._docId);
                    } else {
                        Objects.requireNonNull(currentSegment.getValidDocIds()).remove(currentDocId);
                        validDocIds.add(recordInfo._docId);
                    }
                    return new RecordLocation(segment, recordInfo._docId, recordInfo._comparisonValue);
                }
                return currentRecordLocation;
            }
            validDocIds.add(recordInfo._docId);
            return new RecordLocation(segment, recordInfo._docId, recordInfo._comparisonValue);
        });
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.UPSERT_PRIMARY_KEYS_COUNT, (long)this._primaryKeyToRecordLocationMap.size());
    }

    public GenericRow updateRecord(GenericRow record, RecordInfo recordInfo) {
        if (this._partialUpsertHandler == null) {
            return record;
        }
        while (!this._partialUpsertHandler.isAllSegmentsLoaded()) {
            LOGGER.info("Sleeping 1 second waiting for all segments loaded for partial-upsert table: {}", (Object)this._tableNameWithType);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        RecordLocation currentRecordLocation = this._primaryKeyToRecordLocationMap.get(PartitionUpsertMetadataManager.hashPrimaryKey(recordInfo._primaryKey, this._hashFunction));
        if (currentRecordLocation != null) {
            if (recordInfo._comparisonValue.compareTo(currentRecordLocation.getComparisonValue()) >= 0) {
                this._reuse.clear();
                GenericRow previousRecord = currentRecordLocation.getSegment().getRecord(currentRecordLocation.getDocId(), this._reuse);
                return this._partialUpsertHandler.merge(previousRecord, record);
            }
            LOGGER.warn("Got late event for partial-upsert: {} (current comparison value: {}, record comparison value: {}), skipping updating the record", new Object[]{record, currentRecordLocation.getComparisonValue(), recordInfo._comparisonValue});
            return record;
        }
        return record;
    }

    public void removeSegment(IndexSegment segment) {
        String segmentName = segment.getSegmentName();
        LOGGER.info("Removing upsert metadata for segment: {}", (Object)segmentName);
        if (!Objects.requireNonNull(segment.getValidDocIds()).getMutableRoaringBitmap().isEmpty()) {
            this._primaryKeyToRecordLocationMap.forEach((primaryKey, recordLocation) -> {
                if (recordLocation.getSegment() == segment) {
                    this._primaryKeyToRecordLocationMap.remove(primaryKey, recordLocation);
                }
            });
        }
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.UPSERT_PRIMARY_KEYS_COUNT, (long)this._primaryKeyToRecordLocationMap.size());
    }

    protected static Object hashPrimaryKey(PrimaryKey primaryKey, UpsertConfig.HashFunction hashFunction) {
        switch (hashFunction) {
            case NONE: {
                return primaryKey;
            }
            case MD5: {
                return new ByteArray(HashUtils.hashMD5(primaryKey.asBytes()));
            }
            case MURMUR3: {
                return new ByteArray(HashUtils.hashMurmur3(primaryKey.asBytes()));
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized hash function %s", hashFunction));
    }

    public static final class RecordInfo {
        private final PrimaryKey _primaryKey;
        private final int _docId;
        private final Comparable _comparisonValue;

        public RecordInfo(PrimaryKey primaryKey, int docId, Comparable comparisonValue) {
            this._primaryKey = primaryKey;
            this._docId = docId;
            this._comparisonValue = comparisonValue;
        }
    }
}

