/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.utils.IngestionConfigUtils;

public class ReplicationUtils {
    private ReplicationUtils() {
    }

    public static boolean useReplication(TableConfig tableConfig) {
        TableType tableType = tableConfig.getTableType();
        if (tableType.equals((Object)TableType.REALTIME)) {
            StreamConfig streamConfig = new StreamConfig(tableConfig.getTableName(), IngestionConfigUtils.getStreamConfigMap((TableConfig)tableConfig));
            return streamConfig.hasHighLevelConsumerType();
        }
        return true;
    }

    public static boolean useReplicasPerPartition(TableConfig tableConfig) {
        TableType tableType = tableConfig.getTableType();
        if (tableType.equals((Object)TableType.REALTIME)) {
            StreamConfig streamConfig = new StreamConfig(tableConfig.getTableName(), IngestionConfigUtils.getStreamConfigMap((TableConfig)tableConfig));
            return streamConfig.hasLowLevelConsumerType();
        }
        return false;
    }
}

